import sys


class SpectrumExporter:
    """
    Handles all data export functionality for PSD data
    """
    
    def __init__(self):
        pass
    
    def dump_to_console(self, psd_data):
        """
        Dump PSD data to console in CSV format
        """
        for ii in range(psd_data.frequencies.shape[0]):
            strrow = "{},{},{},{},{}".format(
                psd_data.devices[ii],
                psd_data.timestamps[ii],
                psd_data.frequencies[ii],
                psd_data.powers[ii],
                psd_data.center_freqs[ii]
            )
            print(strrow)
    
    def write_csv(self, psd_data, file_handle):
        """
        Write PSD data to CSV file
        """
        import logging
        file_handle.write("frequency,power,center_freq\n")
        for ii in range(psd_data.frequencies.shape[0]):
            logging.getLogger(__name__).debug(psd_data.frequencies[ii])
            logging.getLogger(__name__).debug(psd_data.powers[ii])
            logging.getLogger(__name__).debug(psd_data.center_freqs[ii])
            file_handle.write("%.3f,%.3f,%.3f\n" % (
                psd_data.frequencies[ii],
                psd_data.powers[ii],
                psd_data.center_freqs[ii]
            ))
    
    def write_csv_to_file(self, psd_data, filename):
        """
        Write PSD data to a CSV file
        """
        with open(filename, 'w') as f:
            self.write_csv(psd_data, f)
    
    def write_csv_to_stdout(self, psd_data):
        """
        Write PSD data to stdout in CSV format
        """
        self.write_csv(psd_data, sys.stdout)
