
import io
import json
import tarfile
import datetime
import stat

def make_archive(metadata, data, basename="rfmonitor", monitor_id=None, gzip=True):
    utcnow = datetime.datetime.utcnow()
    ts = int(utcnow.timestamp() * 1e6)

    # Encode the metadata into an in-memory file-like buffer.
    mb = io.BytesIO()
    mb.write(json.dumps(metadata).encode("utf-8"))
    mb.seek(0)
    mtf = tarfile.TarInfo(name=f"{basename}-{monitor_id}-{ts}.sigmf-meta")
    mtf.size = mb.getbuffer().nbytes
    mtf.mtime = utcnow.timestamp()
    mtf.type = tarfile.REGTYPE
    mtf.mode = stat.S_IRUSR | stat.S_IRGRP

    # Encode the data into an in-memory file-like buffer.
    db = io.BytesIO()
    db.write(data)
    db.seek(0)
    dtf = tarfile.TarInfo(name=f"{basename}-{monitor_id}-{ts}.sigmf-data")
    dtf.size = db.getbuffer().nbytes
    dtf.mtime = utcnow.timestamp()
    dtf.type = tarfile.REGTYPE
    dtf.mode = stat.S_IRUSR | stat.S_IRGRP

    tb = io.BytesIO()
    tmode = "w"
    if gzip:
        tmode = "w|gz"
    with tarfile.open(fileobj=tb, mode=tmode) as tf:
        tf.addfile(mtf, fileobj=mb)
        tf.addfile(dtf, fileobj=db)
    tb.seek(0)

    tbb = tb.getbuffer().tobytes()
    #with open("/tmp/rfmonitor.sigmf-archive", mode="wb") as f:
    #    f.write(tbb)

    return tbb
