<!--
SPDX-FileCopyrightText: 2018-present University of Utah <powder-contact@powderwireless.net>
SPDX-License-Identifier: Apache-2.0
-->

# powder-rfmonitor (POWDER and OpenZMS Python3 SDR RF Monitor Software)

The POWDER rfmonitor software periodically samples the RF spectrum using NI
SDRs (e.g. B210, X310, N310) and the NI UHD drivers.  It can log, store to
disk, or report RF observations in several formats, protocols, and data
kinds (e.g. PSD or spectrogram).  It supports the [OpenZMS
software](https://openzms.net), a prototype automatic spectrum-sharing and
-management system for radio dynamic zones (RDZs), and provides PSD and
spectrogram data to OpenZMS in static or dynamically configurable,
multi-task flows.  (OpenZMS operates the [POWDER-RDZ](https://rdz.powderwireless.net)
in the [POWDER wireless testbed](https://www.powderwireless.net) in Salt
Lake City, Utah, part of the NSF-sponsored Platforms for Advanced Wireless
Research program, to create .


## Installing from source

You can install this library and its tools with `virtualenv`:

```
python -m venv path/to/your/venv
. path/to/your/venv/bin/activate
pip install .
```

(Add the `'[zms]'` postfix to `pip install .` if you want to install OpenZMS
dependencies to enable various OpenZMS integration modes.  Add the `'[dev]'`
postfix to `pip install .` if you want to install dev mode dependencies.)

Then you can run `rfmonitor --help` or `python3 -m monitor`.  Leave the
`virtualenv` via `deactivate`.

You can also install locally with `pip`:

```
pip install --user .
```


## Install from Ubuntu Packages

We provide packages for Ubuntu 22 and 24 at
https://repos.emulab.net/powder-endpoints/ubuntu .  These are CI-built via
https://gitlab.flux.utah.edu/powderrenewpublic/rfmonitor-deb .  Note that if
you want to install with OpenZMS integration mode enabled, you must also add
the https://repos.emulab.net/openzms-testing/ubuntu repository, which
contains the suggested `python3-zmsclient` dependency.


## Running the `monitor`

`rfmonitor --help` will show you an extensive list of parameters.  You can
run the monitor in many modes.

  * By default, `monitor` will output a single aggregate PSD from a sweep
    over the default frequency range (`100e6-6e9`).

  * If you specify `--zms-mode`, the monitor will attempt to connect to
    OpenZMS and send RF data product(s) as OpenZMS `Observations`, running
    in one of several OpenZMS modes: `static` (send a specific RF data
    product over and over); `configurable` (change "macro" parameters like
    `gain`); or `taskable` (define several actions and run instances of them
    called tasks).  In ZMS mode, you must specify several other parameters:
	
	  * `--element-token`: The token used to authenticate to OpenZMS each
        time an Observation is created

	  * `--monitor-id`: The OpenZMS monitor ID (a UUID) to associate each
        Observation with
		
	  * `--zmc-http`: The base URL of the `zms-zmc` service
        (e.g. `http://localhost:8010/v1`)

	  * `--dst-http`: The base URL of the `zms-dst` service
        (e.g. `http://localhost:8020/v1`)

      * `--zms-format`: The Observation data format; defaults to `sigmf`.
        (Note that this monitor sends PSD and spectrogram data products
        using the [NTIA SigMF extensions](https://github.com/NTIA/sigmf-ns-ntia),
        particularly the [`ntia-algorithm`](https://github.com/NTIA/sigmf-ns-ntia/blob/master/ntia-algorithm.sigmf-ext.md)
        extension.
		
	  * `--no-dynamic` forces the monitor to run in `static` OpenZMS mode,
        which does not send OpenZMS heartbeats nor subscribe to OpenZMS
        events such as reconfiguration or status change requests
        (`configurable` mode) nor task creation or deletion events
        (`taskable` mode)

  * If you specify `--plot` (in an X11-enabled terminal), you will be shown
    live-updating PSD and spectrogram plots for each RF observation.
	
