import functools
from typing import (
    Any,
    Callable,
    Concatenate,
    ParamSpec,
    TypeVar,
    cast,
)

from .api.dataset.create_dataset import sync_detailed as create_dataset_sync_detailed
from .api.dataset.create_dataset_series import (
    sync_detailed as create_dataset_series_sync_detailed,
)
from .api.dataset.delete_dataset import sync_detailed as delete_dataset_sync_detailed
from .api.dataset.delete_dataset_series import (
    sync_detailed as delete_dataset_series_sync_detailed,
)
from .api.dataset.get_dataset import sync_detailed as get_dataset_sync_detailed
from .api.dataset.list_datasets import sync_detailed as list_datasets_sync_detailed
from .api.dataset.update_dataset import sync_detailed as update_dataset_sync_detailed
from .api.metric.create_metric import sync_detailed as create_metric_sync_detailed
from .api.metric.delete_metric import sync_detailed as delete_metric_sync_detailed
from .api.metric.get_metric import sync_detailed as get_metric_sync_detailed
from .api.metric.list_metrics import sync_detailed as list_metrics_sync_detailed
from .api.metric.update_metric import sync_detailed as update_metric_sync_detailed
from .api.observation.create_observation import (
    sync_detailed as create_observation_sync_detailed,
)
from .api.observation.delete_observation import (
    sync_detailed as delete_observation_sync_detailed,
)
from .api.observation.get_observation import (
    sync_detailed as get_observation_sync_detailed,
)
from .api.observation.get_observation_raw import (
    sync_detailed as get_observation_raw_sync_detailed,
)
from .api.observation.list_observations import (
    sync_detailed as list_observations_sync_detailed,
)
from .api.observation.update_observation import (
    sync_detailed as update_observation_sync_detailed,
)
from .api.propsim.delete_propsim import sync_detailed as delete_propsim_sync_detailed
from .api.propsim.get_propsim import sync_detailed as get_propsim_sync_detailed
from .api.propsim.get_propsim_job import sync_detailed as get_propsim_job_sync_detailed
from .api.propsim.get_propsim_job_output import (
    sync_detailed as get_propsim_job_output_sync_detailed,
)
from .api.propsim.list_propsim_job_outputs import (
    sync_detailed as list_propsim_job_outputs_sync_detailed,
)
from .api.propsim.list_propsim_jobs import (
    sync_detailed as list_propsim_jobs_sync_detailed,
)
from .api.propsim.list_propsims import sync_detailed as list_propsims_sync_detailed
from .api.series.create_series import sync_detailed as create_series_sync_detailed
from .api.series.create_series_geolocation import (
    sync_detailed as create_series_geolocation_sync_detailed,
)
from .api.series.create_series_grant import (
    sync_detailed as create_series_grant_sync_detailed,
)
from .api.series.delete_series import sync_detailed as delete_series_sync_detailed
from .api.series.delete_series_geolocation import (
    sync_detailed as delete_series_geolocation_sync_detailed,
)
from .api.series.delete_series_grant import (
    sync_detailed as delete_series_grant_sync_detailed,
)
from .api.series.get_series import sync_detailed as get_series_sync_detailed
from .api.series.list_series import sync_detailed as list_series_sync_detailed
from .api.series.list_series_values_influx import (
    sync_detailed as list_series_values_influx_sync_detailed,
)
from .api.series.list_series_values_internal import (
    sync_detailed as list_series_values_internal_sync_detailed,
)
from .api.series.update_series import sync_detailed as update_series_sync_detailed
from .api.stats.get_stats_summary import (
    sync_detailed as get_stats_summary_sync_detailed,
)
from .api.store.create_store import sync_detailed as create_store_sync_detailed
from .api.store.delete_store import sync_detailed as delete_store_sync_detailed
from .api.store.get_store import sync_detailed as get_store_sync_detailed
from .api.store.list_stores import sync_detailed as list_stores_sync_detailed
from .api.store.update_store import sync_detailed as update_store_sync_detailed
from .api.subscription.create_subscription import (
    sync_detailed as create_subscription_sync_detailed,
)
from .api.subscription.delete_subscription import (
    sync_detailed as delete_subscription_sync_detailed,
)
from .api.subscription.get_subscription_events import (
    sync_detailed as get_subscription_events_sync_detailed,
)
from .api.subscription.get_subscriptions import (
    sync_detailed as get_subscriptions_sync_detailed,
)
from .api.value.create_value import sync_detailed as create_value_sync_detailed
from .api.version.get_version import sync_detailed as get_version_sync_detailed

P = ParamSpec("P")
R = TypeVar("R")


def wraps_method(
    wrapped: Callable[Concatenate[Any, P], R],
    wrapper_name: str,
    **kwargs,
) -> Callable[[Callable[Concatenate[Any, P], R]], Callable[Concatenate[Any, P], R]]:
    def decorator(
        f: Callable[Concatenate[Any, P], R],
    ) -> Callable[Concatenate[Any, P], R]:
        @functools.wraps(wrapped, **kwargs)
        def wrapper(self: Any, *args: P.args, **kwargs: P.kwargs) -> R:
            return f(self, *args, **kwargs)

        if wrapper_name:
            wrapper.__name__ = wrapper_name
        return cast(Callable[Concatenate[Any, P], R], wrapper)

    return decorator


class ClientApiMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(self, *args, **kwargs)

    @wraps_method(get_version_sync_detailed, "get_version")  # type: ignore
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_sync_detailed, *args, **kwargs)

    @wraps_method(get_stats_summary_sync_detailed, "get_stats_summary")  # type: ignore
    def get_stats_summary(self, *args, **kwargs):
        return self._call_api_func(get_stats_summary_sync_detailed, *args, **kwargs)

    @wraps_method(list_observations_sync_detailed, "list_observations")  # type: ignore
    def list_observations(self, *args, **kwargs):
        return self._call_api_func(list_observations_sync_detailed, *args, **kwargs)

    @wraps_method(create_observation_sync_detailed, "create_observation")  # type: ignore
    def create_observation(self, *args, **kwargs):
        return self._call_api_func(create_observation_sync_detailed, *args, **kwargs)

    @wraps_method(get_observation_sync_detailed, "get_observation")  # type: ignore
    def get_observation(self, *args, **kwargs):
        return self._call_api_func(get_observation_sync_detailed, *args, **kwargs)

    @wraps_method(update_observation_sync_detailed, "update_observation")  # type: ignore
    def update_observation(self, *args, **kwargs):
        return self._call_api_func(update_observation_sync_detailed, *args, **kwargs)

    @wraps_method(delete_observation_sync_detailed, "delete_observation")  # type: ignore
    def delete_observation(self, *args, **kwargs):
        return self._call_api_func(delete_observation_sync_detailed, *args, **kwargs)

    @wraps_method(get_observation_raw_sync_detailed, "get_observation_raw")  # type: ignore
    def get_observation_raw(self, *args, **kwargs):
        return self._call_api_func(get_observation_raw_sync_detailed, *args, **kwargs)

    @wraps_method(list_metrics_sync_detailed, "list_metrics")  # type: ignore
    def list_metrics(self, *args, **kwargs):
        return self._call_api_func(list_metrics_sync_detailed, *args, **kwargs)

    @wraps_method(create_metric_sync_detailed, "create_metric")  # type: ignore
    def create_metric(self, *args, **kwargs):
        return self._call_api_func(create_metric_sync_detailed, *args, **kwargs)

    @wraps_method(get_metric_sync_detailed, "get_metric")  # type: ignore
    def get_metric(self, *args, **kwargs):
        return self._call_api_func(get_metric_sync_detailed, *args, **kwargs)

    @wraps_method(update_metric_sync_detailed, "update_metric")  # type: ignore
    def update_metric(self, *args, **kwargs):
        return self._call_api_func(update_metric_sync_detailed, *args, **kwargs)

    @wraps_method(delete_metric_sync_detailed, "delete_metric")  # type: ignore
    def delete_metric(self, *args, **kwargs):
        return self._call_api_func(delete_metric_sync_detailed, *args, **kwargs)

    @wraps_method(create_value_sync_detailed, "create_value")  # type: ignore
    def create_value(self, *args, **kwargs):
        return self._call_api_func(create_value_sync_detailed, *args, **kwargs)

    @wraps_method(list_series_sync_detailed, "list_series")  # type: ignore
    def list_series(self, *args, **kwargs):
        return self._call_api_func(list_series_sync_detailed, *args, **kwargs)

    @wraps_method(create_series_sync_detailed, "create_series")  # type: ignore
    def create_series(self, *args, **kwargs):
        return self._call_api_func(create_series_sync_detailed, *args, **kwargs)

    @wraps_method(get_series_sync_detailed, "get_series")  # type: ignore
    def get_series(self, *args, **kwargs):
        return self._call_api_func(get_series_sync_detailed, *args, **kwargs)

    @wraps_method(update_series_sync_detailed, "update_series")  # type: ignore
    def update_series(self, *args, **kwargs):
        return self._call_api_func(update_series_sync_detailed, *args, **kwargs)

    @wraps_method(delete_series_sync_detailed, "delete_series")  # type: ignore
    def delete_series(self, *args, **kwargs):
        return self._call_api_func(delete_series_sync_detailed, *args, **kwargs)

    @wraps_method(
        list_series_values_internal_sync_detailed, "list_series_values_internal"
    )  # type: ignore
    def list_series_values_internal(self, *args, **kwargs):
        return self._call_api_func(
            list_series_values_internal_sync_detailed, *args, **kwargs
        )

    @wraps_method(list_series_values_influx_sync_detailed, "list_series_values_influx")  # type: ignore
    def list_series_values_influx(self, *args, **kwargs):
        return self._call_api_func(
            list_series_values_influx_sync_detailed, *args, **kwargs
        )

    @wraps_method(create_series_geolocation_sync_detailed, "create_series_geolocation")  # type: ignore
    def create_series_geolocation(self, *args, **kwargs):
        return self._call_api_func(
            create_series_geolocation_sync_detailed, *args, **kwargs
        )

    @wraps_method(delete_series_geolocation_sync_detailed, "delete_series_geolocation")  # type: ignore
    def delete_series_geolocation(self, *args, **kwargs):
        return self._call_api_func(
            delete_series_geolocation_sync_detailed, *args, **kwargs
        )

    @wraps_method(create_series_grant_sync_detailed, "create_series_grant")  # type: ignore
    def create_series_grant(self, *args, **kwargs):
        return self._call_api_func(create_series_grant_sync_detailed, *args, **kwargs)

    @wraps_method(delete_series_grant_sync_detailed, "delete_series_grant")  # type: ignore
    def delete_series_grant(self, *args, **kwargs):
        return self._call_api_func(delete_series_grant_sync_detailed, *args, **kwargs)

    @wraps_method(list_datasets_sync_detailed, "list_datasets")  # type: ignore
    def list_datasets(self, *args, **kwargs):
        return self._call_api_func(list_datasets_sync_detailed, *args, **kwargs)

    @wraps_method(create_dataset_sync_detailed, "create_dataset")  # type: ignore
    def create_dataset(self, *args, **kwargs):
        return self._call_api_func(create_dataset_sync_detailed, *args, **kwargs)

    @wraps_method(get_dataset_sync_detailed, "get_dataset")  # type: ignore
    def get_dataset(self, *args, **kwargs):
        return self._call_api_func(get_dataset_sync_detailed, *args, **kwargs)

    @wraps_method(update_dataset_sync_detailed, "update_dataset")  # type: ignore
    def update_dataset(self, *args, **kwargs):
        return self._call_api_func(update_dataset_sync_detailed, *args, **kwargs)

    @wraps_method(delete_dataset_sync_detailed, "delete_dataset")  # type: ignore
    def delete_dataset(self, *args, **kwargs):
        return self._call_api_func(delete_dataset_sync_detailed, *args, **kwargs)

    @wraps_method(create_dataset_series_sync_detailed, "create_dataset_series")  # type: ignore
    def create_dataset_series(self, *args, **kwargs):
        return self._call_api_func(create_dataset_series_sync_detailed, *args, **kwargs)

    @wraps_method(delete_dataset_series_sync_detailed, "delete_dataset_series")  # type: ignore
    def delete_dataset_series(self, *args, **kwargs):
        return self._call_api_func(delete_dataset_series_sync_detailed, *args, **kwargs)

    @wraps_method(list_stores_sync_detailed, "list_stores")  # type: ignore
    def list_stores(self, *args, **kwargs):
        return self._call_api_func(list_stores_sync_detailed, *args, **kwargs)

    @wraps_method(create_store_sync_detailed, "create_store")  # type: ignore
    def create_store(self, *args, **kwargs):
        return self._call_api_func(create_store_sync_detailed, *args, **kwargs)

    @wraps_method(get_store_sync_detailed, "get_store")  # type: ignore
    def get_store(self, *args, **kwargs):
        return self._call_api_func(get_store_sync_detailed, *args, **kwargs)

    @wraps_method(update_store_sync_detailed, "update_store")  # type: ignore
    def update_store(self, *args, **kwargs):
        return self._call_api_func(update_store_sync_detailed, *args, **kwargs)

    @wraps_method(delete_store_sync_detailed, "delete_store")  # type: ignore
    def delete_store(self, *args, **kwargs):
        return self._call_api_func(delete_store_sync_detailed, *args, **kwargs)

    @wraps_method(list_propsims_sync_detailed, "list_propsims")  # type: ignore
    def list_propsims(self, *args, **kwargs):
        return self._call_api_func(list_propsims_sync_detailed, *args, **kwargs)

    @wraps_method(get_propsim_sync_detailed, "get_propsim")  # type: ignore
    def get_propsim(self, *args, **kwargs):
        return self._call_api_func(get_propsim_sync_detailed, *args, **kwargs)

    @wraps_method(delete_propsim_sync_detailed, "delete_propsim")  # type: ignore
    def delete_propsim(self, *args, **kwargs):
        return self._call_api_func(delete_propsim_sync_detailed, *args, **kwargs)

    @wraps_method(list_propsim_jobs_sync_detailed, "list_propsim_jobs")  # type: ignore
    def list_propsim_jobs(self, *args, **kwargs):
        return self._call_api_func(list_propsim_jobs_sync_detailed, *args, **kwargs)

    @wraps_method(get_propsim_job_sync_detailed, "get_propsim_job")  # type: ignore
    def get_propsim_job(self, *args, **kwargs):
        return self._call_api_func(get_propsim_job_sync_detailed, *args, **kwargs)

    @wraps_method(list_propsim_job_outputs_sync_detailed, "list_propsim_job_outputs")  # type: ignore
    def list_propsim_job_outputs(self, *args, **kwargs):
        return self._call_api_func(
            list_propsim_job_outputs_sync_detailed, *args, **kwargs
        )

    @wraps_method(get_propsim_job_output_sync_detailed, "get_propsim_job_output")  # type: ignore
    def get_propsim_job_output(self, *args, **kwargs):
        return self._call_api_func(
            get_propsim_job_output_sync_detailed, *args, **kwargs
        )

    @wraps_method(get_subscriptions_sync_detailed, "get_subscriptions")  # type: ignore
    def get_subscriptions(self, *args, **kwargs):
        return self._call_api_func(get_subscriptions_sync_detailed, *args, **kwargs)

    @wraps_method(create_subscription_sync_detailed, "create_subscription")  # type: ignore
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(create_subscription_sync_detailed, *args, **kwargs)

    @wraps_method(delete_subscription_sync_detailed, "delete_subscription")  # type: ignore
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(delete_subscription_sync_detailed, *args, **kwargs)

    @wraps_method(get_subscription_events_sync_detailed, "get_subscription_events")  # type: ignore
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_sync_detailed, *args, **kwargs
        )
