import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_propsims_end_field import ListPropsimsEndField
from ...models.list_propsims_kind import ListPropsimsKind
from ...models.list_propsims_sort import ListPropsimsSort
from ...models.list_propsims_start_field import ListPropsimsStartField
from ...models.propsim_list import PropsimList
from ...models.propsim_status import PropsimStatus
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    element_id: Union[Unset, str] = UNSET,
    service_id: Union[Unset, str] = UNSET,
    radio_port_id: Union[Unset, str] = UNSET,
    propsim: Union[Unset, str] = UNSET,
    freq_min: Union[Unset, int] = UNSET,
    freq_max: Union[Unset, int] = UNSET,
    gain_min: Union[Unset, float] = UNSET,
    gain_max: Union[Unset, float] = UNSET,
    status: Union[Unset, PropsimStatus] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListPropsimsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListPropsimsKind] = UNSET,
    end_field: Union[Unset, ListPropsimsEndField] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    sort: Union[Unset, ListPropsimsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["element_id"] = element_id

    params["service_id"] = service_id

    params["radio_port_id"] = radio_port_id

    params["propsim"] = propsim

    params["freq_min"] = freq_min

    params["freq_max"] = freq_max

    params["gain_min"] = gain_min

    params["gain_max"] = gain_max

    json_status: Union[Unset, str] = UNSET
    if not isinstance(status, Unset):
        json_status = status.value

    params["status"] = json_status

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    params["page"] = page

    params["items_per_page"] = items_per_page

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/propsims",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, PropsimList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = PropsimList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.NOT_FOUND:
        try:
            response_404 = Error.from_dict(response.json())

            return response_404
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, PropsimList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    service_id: Union[Unset, str] = UNSET,
    radio_port_id: Union[Unset, str] = UNSET,
    propsim: Union[Unset, str] = UNSET,
    freq_min: Union[Unset, int] = UNSET,
    freq_max: Union[Unset, int] = UNSET,
    gain_min: Union[Unset, float] = UNSET,
    gain_max: Union[Unset, float] = UNSET,
    status: Union[Unset, PropsimStatus] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListPropsimsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListPropsimsKind] = UNSET,
    end_field: Union[Unset, ListPropsimsEndField] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    sort: Union[Unset, ListPropsimsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, PropsimList]]:
    """Retrieve a list of propsims.

    Args:
        element_id (Union[Unset, str]): Filters by element_id.
        service_id (Union[Unset, str]): Filters by service_id.
        radio_port_id (Union[Unset, str]): Filters by radio_port_id.
        propsim (Union[Unset, str]): Filters by name or description.
        freq_min (Union[Unset, int]): Filters for propsims with frequency greater than or equal to
            this value (in Hz).
        freq_max (Union[Unset, int]): Filters for propsims with frequency less than or equal to
            this value (in Hz).
        gain_min (Union[Unset, float]): Filters for propsims with gain greater than or equal to
            this value (in dBi).
        gain_max (Union[Unset, float]): Filters for propsims with gain less than or equal to this
            value (in dBi).
        status (Union[Unset, PropsimStatus]): The status of a Propsim job or service.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListPropsimsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListPropsimsKind]):
        end_field (Union[Unset, ListPropsimsEndField]): Name of field used in end time comparison.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        sort (Union[Unset, ListPropsimsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, PropsimList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        service_id=service_id,
        radio_port_id=radio_port_id,
        propsim=propsim,
        freq_min=freq_min,
        freq_max=freq_max,
        gain_min=gain_min,
        gain_max=gain_max,
        status=status,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        page=page,
        items_per_page=items_per_page,
        sort=sort,
        sort_asc=sort_asc,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    service_id: Union[Unset, str] = UNSET,
    radio_port_id: Union[Unset, str] = UNSET,
    propsim: Union[Unset, str] = UNSET,
    freq_min: Union[Unset, int] = UNSET,
    freq_max: Union[Unset, int] = UNSET,
    gain_min: Union[Unset, float] = UNSET,
    gain_max: Union[Unset, float] = UNSET,
    status: Union[Unset, PropsimStatus] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListPropsimsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListPropsimsKind] = UNSET,
    end_field: Union[Unset, ListPropsimsEndField] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    sort: Union[Unset, ListPropsimsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, PropsimList]]:
    """Retrieve a list of propsims.

    Args:
        element_id (Union[Unset, str]): Filters by element_id.
        service_id (Union[Unset, str]): Filters by service_id.
        radio_port_id (Union[Unset, str]): Filters by radio_port_id.
        propsim (Union[Unset, str]): Filters by name or description.
        freq_min (Union[Unset, int]): Filters for propsims with frequency greater than or equal to
            this value (in Hz).
        freq_max (Union[Unset, int]): Filters for propsims with frequency less than or equal to
            this value (in Hz).
        gain_min (Union[Unset, float]): Filters for propsims with gain greater than or equal to
            this value (in dBi).
        gain_max (Union[Unset, float]): Filters for propsims with gain less than or equal to this
            value (in dBi).
        status (Union[Unset, PropsimStatus]): The status of a Propsim job or service.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListPropsimsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListPropsimsKind]):
        end_field (Union[Unset, ListPropsimsEndField]): Name of field used in end time comparison.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        sort (Union[Unset, ListPropsimsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, PropsimList]
    """

    return sync_detailed(
        client=client,
        element_id=element_id,
        service_id=service_id,
        radio_port_id=radio_port_id,
        propsim=propsim,
        freq_min=freq_min,
        freq_max=freq_max,
        gain_min=gain_min,
        gain_max=gain_max,
        status=status,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        page=page,
        items_per_page=items_per_page,
        sort=sort,
        sort_asc=sort_asc,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    service_id: Union[Unset, str] = UNSET,
    radio_port_id: Union[Unset, str] = UNSET,
    propsim: Union[Unset, str] = UNSET,
    freq_min: Union[Unset, int] = UNSET,
    freq_max: Union[Unset, int] = UNSET,
    gain_min: Union[Unset, float] = UNSET,
    gain_max: Union[Unset, float] = UNSET,
    status: Union[Unset, PropsimStatus] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListPropsimsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListPropsimsKind] = UNSET,
    end_field: Union[Unset, ListPropsimsEndField] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    sort: Union[Unset, ListPropsimsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, PropsimList]]:
    """Retrieve a list of propsims.

    Args:
        element_id (Union[Unset, str]): Filters by element_id.
        service_id (Union[Unset, str]): Filters by service_id.
        radio_port_id (Union[Unset, str]): Filters by radio_port_id.
        propsim (Union[Unset, str]): Filters by name or description.
        freq_min (Union[Unset, int]): Filters for propsims with frequency greater than or equal to
            this value (in Hz).
        freq_max (Union[Unset, int]): Filters for propsims with frequency less than or equal to
            this value (in Hz).
        gain_min (Union[Unset, float]): Filters for propsims with gain greater than or equal to
            this value (in dBi).
        gain_max (Union[Unset, float]): Filters for propsims with gain less than or equal to this
            value (in dBi).
        status (Union[Unset, PropsimStatus]): The status of a Propsim job or service.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListPropsimsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListPropsimsKind]):
        end_field (Union[Unset, ListPropsimsEndField]): Name of field used in end time comparison.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        sort (Union[Unset, ListPropsimsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, PropsimList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        service_id=service_id,
        radio_port_id=radio_port_id,
        propsim=propsim,
        freq_min=freq_min,
        freq_max=freq_max,
        gain_min=gain_min,
        gain_max=gain_max,
        status=status,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        page=page,
        items_per_page=items_per_page,
        sort=sort,
        sort_asc=sort_asc,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    service_id: Union[Unset, str] = UNSET,
    radio_port_id: Union[Unset, str] = UNSET,
    propsim: Union[Unset, str] = UNSET,
    freq_min: Union[Unset, int] = UNSET,
    freq_max: Union[Unset, int] = UNSET,
    gain_min: Union[Unset, float] = UNSET,
    gain_max: Union[Unset, float] = UNSET,
    status: Union[Unset, PropsimStatus] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListPropsimsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListPropsimsKind] = UNSET,
    end_field: Union[Unset, ListPropsimsEndField] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    sort: Union[Unset, ListPropsimsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, PropsimList]]:
    """Retrieve a list of propsims.

    Args:
        element_id (Union[Unset, str]): Filters by element_id.
        service_id (Union[Unset, str]): Filters by service_id.
        radio_port_id (Union[Unset, str]): Filters by radio_port_id.
        propsim (Union[Unset, str]): Filters by name or description.
        freq_min (Union[Unset, int]): Filters for propsims with frequency greater than or equal to
            this value (in Hz).
        freq_max (Union[Unset, int]): Filters for propsims with frequency less than or equal to
            this value (in Hz).
        gain_min (Union[Unset, float]): Filters for propsims with gain greater than or equal to
            this value (in dBi).
        gain_max (Union[Unset, float]): Filters for propsims with gain less than or equal to this
            value (in dBi).
        status (Union[Unset, PropsimStatus]): The status of a Propsim job or service.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListPropsimsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListPropsimsKind]):
        end_field (Union[Unset, ListPropsimsEndField]): Name of field used in end time comparison.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        sort (Union[Unset, ListPropsimsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, PropsimList]
    """

    return (
        await asyncio_detailed(
            client=client,
            element_id=element_id,
            service_id=service_id,
            radio_port_id=radio_port_id,
            propsim=propsim,
            freq_min=freq_min,
            freq_max=freq_max,
            gain_min=gain_min,
            gain_max=gain_max,
            status=status,
            start=start,
            start_field=start_field,
            end=end,
            kind=kind,
            end_field=end_field,
            page=page,
            items_per_page=items_per_page,
            sort=sort,
            sort_asc=sort_asc,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
