from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.constraint import Constraint


T = TypeVar("T", bound="ConstraintList")


@_attrs_define
class ConstraintList:
    """
    Attributes:
        constraints (List['Constraint']):
    """

    constraints: List["Constraint"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"constraints": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        constraints = []
        for constraints_item_data in self.constraints:
            constraints_item = constraints_item_data.to_dict()
            constraints.append(constraints_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "constraints": constraints,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.constraint import Constraint

        d = src_dict.copy()
        constraints = []
        _constraints = d.pop("constraints")
        for constraints_item_data in _constraints:
            constraints_item = Constraint.from_dict(constraints_item_data)

            constraints.append(constraints_item)

        constraint_list = cls(
            constraints=constraints,
        )

        constraint_list.additional_properties = d
        return constraint_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.constraint import Constraint

    ns["Constraint"] = Constraint
