from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.constraint_change import ConstraintChange


T = TypeVar("T", bound="ConstraintChangeList")


@_attrs_define
class ConstraintChangeList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        constraint_changes (List['ConstraintChange']):
    """

    page: int
    total: int
    pages: int
    constraint_changes: List["ConstraintChange"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        constraint_changes = []
        for constraint_changes_item_data in self.constraint_changes:
            constraint_changes_item = constraint_changes_item_data.to_dict()
            constraint_changes.append(constraint_changes_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "constraint_changes": constraint_changes,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.constraint_change import ConstraintChange

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        constraint_changes = []
        _constraint_changes = d.pop("constraint_changes")
        for constraint_changes_item_data in _constraint_changes:
            constraint_changes_item = ConstraintChange.from_dict(
                constraint_changes_item_data
            )

            constraint_changes.append(constraint_changes_item)

        constraint_change_list = cls(
            page=page,
            total=total,
            pages=pages,
            constraint_changes=constraint_changes,
        )

        constraint_change_list.additional_properties = d
        return constraint_change_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.constraint_change import ConstraintChange

    ns["ConstraintChange"] = ConstraintChange
