import functools
from typing import (
    Any,
    Callable,
    Concatenate,
    ParamSpec,
    TypeVar,
    cast,
)

from .api.alarm_grant.list_alarm_grant_logs import (
    sync_detailed as list_alarm_grant_logs_sync_detailed,
)
from .api.alarm_grant.list_alarm_grants import (
    sync_detailed as list_alarm_grants_sync_detailed,
)
from .api.change_constraint.list_change_constraints import (
    sync_detailed as list_change_constraints_sync_detailed,
)
from .api.change_grant.list_change_grants import (
    sync_detailed as list_change_grants_sync_detailed,
)
from .api.general.get_version import sync_detailed as get_version_sync_detailed
from .api.subscription.create_subscription import (
    sync_detailed as create_subscription_sync_detailed,
)
from .api.subscription.delete_subscription import (
    sync_detailed as delete_subscription_sync_detailed,
)
from .api.subscription.get_subscription_events import (
    sync_detailed as get_subscription_events_sync_detailed,
)
from .api.subscription.get_subscriptions import (
    sync_detailed as get_subscriptions_sync_detailed,
)

P = ParamSpec("P")
R = TypeVar("R")


def wraps_method(
    wrapped: Callable[Concatenate[Any, P], R],
    wrapper_name: str,
    **kwargs,
) -> Callable[[Callable[Concatenate[Any, P], R]], Callable[Concatenate[Any, P], R]]:
    def decorator(
        f: Callable[Concatenate[Any, P], R],
    ) -> Callable[Concatenate[Any, P], R]:
        @functools.wraps(wrapped, **kwargs)
        def wrapper(self: Any, *args: P.args, **kwargs: P.kwargs) -> R:
            return f(self, *args, **kwargs)

        if wrapper_name:
            wrapper.__name__ = wrapper_name
        return cast(Callable[Concatenate[Any, P], R], wrapper)

    return decorator


class ClientApiMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(self, *args, **kwargs)

    @wraps_method(get_version_sync_detailed, "get_version")  # type: ignore
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_sync_detailed, *args, **kwargs)

    @wraps_method(list_alarm_grants_sync_detailed, "list_alarm_grants")  # type: ignore
    def list_alarm_grants(self, *args, **kwargs):
        return self._call_api_func(list_alarm_grants_sync_detailed, *args, **kwargs)

    @wraps_method(list_alarm_grant_logs_sync_detailed, "list_alarm_grant_logs")  # type: ignore
    def list_alarm_grant_logs(self, *args, **kwargs):
        return self._call_api_func(list_alarm_grant_logs_sync_detailed, *args, **kwargs)

    @wraps_method(list_change_constraints_sync_detailed, "list_change_constraints")  # type: ignore
    def list_change_constraints(self, *args, **kwargs):
        return self._call_api_func(
            list_change_constraints_sync_detailed, *args, **kwargs
        )

    @wraps_method(list_change_grants_sync_detailed, "list_change_grants")  # type: ignore
    def list_change_grants(self, *args, **kwargs):
        return self._call_api_func(list_change_grants_sync_detailed, *args, **kwargs)

    @wraps_method(get_subscriptions_sync_detailed, "get_subscriptions")  # type: ignore
    def get_subscriptions(self, *args, **kwargs):
        return self._call_api_func(get_subscriptions_sync_detailed, *args, **kwargs)

    @wraps_method(create_subscription_sync_detailed, "create_subscription")  # type: ignore
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(create_subscription_sync_detailed, *args, **kwargs)

    @wraps_method(delete_subscription_sync_detailed, "delete_subscription")  # type: ignore
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(delete_subscription_sync_detailed, *args, **kwargs)

    @wraps_method(get_subscription_events_sync_detailed, "get_subscription_events")  # type: ignore
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_sync_detailed, *args, **kwargs
        )
