import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="ConstraintChange")


@_attrs_define
class ConstraintChange:
    """Describes a recommended grant constraint change.

    Attributes:
        grant_id (str): The id of the associated grant.
        constraint_id (str): The id of the associated grant constraint.
        id (Union[Unset, str]): The id of the constraint change.
        observation_id (Union[None, Unset, str]): The id of the triggering Observation.
        grant_alarm_id (Union[None, Unset, str]): The id of the associated GrantAlarm, if any.
        int_grant_id (Union[None, Unset, str]): The id of the interfered grant, if any.
        min_freq (Union[None, Unset, int]): The start of the frequency range (inclusive) that this grant includes (Hz).
        max_freq (Union[None, Unset, int]): The end of the frequency range (inclusive) that this grant includes (Hz).
        bandwidth (Union[None, Unset, int]): If set, a bandwidth smaller than the above min_freq/max_freq range; ZMS is
            free to choose any such bandwidth if it allows the grant.
        max_eirp (Union[None, Unset, float]): The maximum EIRP (effective isotropic radiated power) that may be used by
            transmitter.
        min_eirp (Union[None, Unset, float]): The minimum EIRP (effective isotropic radiated power) that may be used by
            transmitter.
        description (Union[None, Unset, str]): A message about the change.
        element_id (Union[None, Unset, str]): The id of the associated element.
        creator_id (Union[Unset, str]): The user id of the creator.
        updater_id (Union[None, Unset, str]): The user id of the updater.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        updated_at (Union[None, Unset, datetime.datetime]): Last modification time.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
    """

    grant_id: str
    constraint_id: str
    id: Union[Unset, str] = UNSET
    observation_id: Union[None, Unset, str] = UNSET
    grant_alarm_id: Union[None, Unset, str] = UNSET
    int_grant_id: Union[None, Unset, str] = UNSET
    min_freq: Union[None, Unset, int] = UNSET
    max_freq: Union[None, Unset, int] = UNSET
    bandwidth: Union[None, Unset, int] = UNSET
    max_eirp: Union[None, Unset, float] = UNSET
    min_eirp: Union[None, Unset, float] = UNSET
    description: Union[None, Unset, str] = UNSET
    element_id: Union[None, Unset, str] = UNSET
    creator_id: Union[Unset, str] = UNSET
    updater_id: Union[None, Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[None, Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "grant_id": {"put": True, "post": None},
        "constraint_id": {"put": True, "post": None},
        "observation_id": {"put": True, "post": None},
        "grant_alarm_id": {"put": True, "post": True},
        "int_grant_id": {"put": True, "post": True},
        "min_freq": {"put": True, "post": None},
        "max_freq": {"put": True, "post": None},
        "bandwidth": {"put": True, "post": None},
        "max_eirp": {"put": True, "post": None},
        "min_eirp": {"put": True, "post": None},
        "description": {"put": None, "post": None},
        "element_id": {"put": True, "post": True},
        "creator_id": {"put": True, "post": True},
        "updater_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "updated_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        grant_id = self.grant_id

        constraint_id = self.constraint_id

        id = self.id

        observation_id: Union[None, Unset, str]
        if isinstance(self.observation_id, Unset):
            observation_id = UNSET
        else:
            observation_id = self.observation_id

        grant_alarm_id: Union[None, Unset, str]
        if isinstance(self.grant_alarm_id, Unset):
            grant_alarm_id = UNSET
        else:
            grant_alarm_id = self.grant_alarm_id

        int_grant_id: Union[None, Unset, str]
        if isinstance(self.int_grant_id, Unset):
            int_grant_id = UNSET
        else:
            int_grant_id = self.int_grant_id

        min_freq: Union[None, Unset, int]
        if isinstance(self.min_freq, Unset):
            min_freq = UNSET
        else:
            min_freq = self.min_freq

        max_freq: Union[None, Unset, int]
        if isinstance(self.max_freq, Unset):
            max_freq = UNSET
        else:
            max_freq = self.max_freq

        bandwidth: Union[None, Unset, int]
        if isinstance(self.bandwidth, Unset):
            bandwidth = UNSET
        else:
            bandwidth = self.bandwidth

        max_eirp: Union[None, Unset, float]
        if isinstance(self.max_eirp, Unset):
            max_eirp = UNSET
        else:
            max_eirp = self.max_eirp

        min_eirp: Union[None, Unset, float]
        if isinstance(self.min_eirp, Unset):
            min_eirp = UNSET
        else:
            min_eirp = self.min_eirp

        description: Union[None, Unset, str]
        if isinstance(self.description, Unset):
            description = UNSET
        else:
            description = self.description

        element_id: Union[None, Unset, str]
        if isinstance(self.element_id, Unset):
            element_id = UNSET
        else:
            element_id = self.element_id

        creator_id = self.creator_id

        updater_id: Union[None, Unset, str]
        if isinstance(self.updater_id, Unset):
            updater_id = UNSET
        else:
            updater_id = self.updater_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[None, Unset, str]
        if isinstance(self.updated_at, Unset):
            updated_at = UNSET
        elif isinstance(self.updated_at, datetime.datetime):
            updated_at = self.updated_at.isoformat()
        else:
            updated_at = self.updated_at

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "grant_id": grant_id,
                "constraint_id": constraint_id,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if observation_id is not UNSET:
            field_dict["observation_id"] = observation_id
        if grant_alarm_id is not UNSET:
            field_dict["grant_alarm_id"] = grant_alarm_id
        if int_grant_id is not UNSET:
            field_dict["int_grant_id"] = int_grant_id
        if min_freq is not UNSET:
            field_dict["min_freq"] = min_freq
        if max_freq is not UNSET:
            field_dict["max_freq"] = max_freq
        if bandwidth is not UNSET:
            field_dict["bandwidth"] = bandwidth
        if max_eirp is not UNSET:
            field_dict["max_eirp"] = max_eirp
        if min_eirp is not UNSET:
            field_dict["min_eirp"] = min_eirp
        if description is not UNSET:
            field_dict["description"] = description
        if element_id is not UNSET:
            field_dict["element_id"] = element_id
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if updater_id is not UNSET:
            field_dict["updater_id"] = updater_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        grant_id = d.pop("grant_id")

        constraint_id = d.pop("constraint_id")

        id = d.pop("id", UNSET)

        def _parse_observation_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        observation_id = _parse_observation_id(d.pop("observation_id", UNSET))

        def _parse_grant_alarm_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        grant_alarm_id = _parse_grant_alarm_id(d.pop("grant_alarm_id", UNSET))

        def _parse_int_grant_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        int_grant_id = _parse_int_grant_id(d.pop("int_grant_id", UNSET))

        def _parse_min_freq(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        min_freq = _parse_min_freq(d.pop("min_freq", UNSET))

        def _parse_max_freq(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_freq = _parse_max_freq(d.pop("max_freq", UNSET))

        def _parse_bandwidth(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        bandwidth = _parse_bandwidth(d.pop("bandwidth", UNSET))

        def _parse_max_eirp(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        max_eirp = _parse_max_eirp(d.pop("max_eirp", UNSET))

        def _parse_min_eirp(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        min_eirp = _parse_min_eirp(d.pop("min_eirp", UNSET))

        def _parse_description(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        description = _parse_description(d.pop("description", UNSET))

        def _parse_element_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        element_id = _parse_element_id(d.pop("element_id", UNSET))

        creator_id = d.pop("creator_id", UNSET)

        def _parse_updater_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        updater_id = _parse_updater_id(d.pop("updater_id", UNSET))

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_updated_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                updated_at_type_0 = isoparse(data)

                return updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        updated_at = _parse_updated_at(d.pop("updated_at", UNSET))

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        constraint_change = cls(
            grant_id=grant_id,
            constraint_id=constraint_id,
            id=id,
            observation_id=observation_id,
            grant_alarm_id=grant_alarm_id,
            int_grant_id=int_grant_id,
            min_freq=min_freq,
            max_freq=max_freq,
            bandwidth=bandwidth,
            max_eirp=max_eirp,
            min_eirp=min_eirp,
            description=description,
            element_id=element_id,
            creator_id=creator_id,
            updater_id=updater_id,
            created_at=created_at,
            updated_at=updated_at,
            deleted_at=deleted_at,
        )

        constraint_change.additional_properties = d
        return constraint_change

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
