import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.monitor_op_status import MonitorOpStatus
from ..models.monitor_status import MonitorStatus
from ..types import UNSET, Unset

T = TypeVar("T", bound="MonitorLog")


@_attrs_define
class MonitorLog:
    """A log entry for a monitor.

    Attributes:
        id (Union[Unset, str]): The id of the monitor log.
        monitor_id (Union[Unset, str]): The id of the monitor.
        status (Union[Unset, MonitorStatus]): The status of the monitor.  This field is determined by the OpenZMS
            monitor controller, and cannot be set by non-administrator users.
        op_status (Union[Unset, MonitorOpStatus]): The operational status of the monitor, as updated by the monitor or
            monitor user.  This must be set as part of the OpenZMS monitor heartbeat protocol.  Administrators may modify
            this field directly via monitor status update.
        message (Union[Unset, str]): A log message.
        creator_id (Union[Unset, str]): The user id of the creator.
        created_at (Union[Unset, datetime.datetime]): Creation time.
    """

    id: Union[Unset, str] = UNSET
    monitor_id: Union[Unset, str] = UNSET
    status: Union[Unset, MonitorStatus] = UNSET
    op_status: Union[Unset, MonitorOpStatus] = UNSET
    message: Union[Unset, str] = UNSET
    creator_id: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "monitor_id": {"put": True, "post": None},
        "status": {"put": True, "post": True},
        "op_status": {"put": True, "post": True},
        "message": {"put": True, "post": None},
        "creator_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        monitor_id = self.monitor_id

        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        op_status: Union[Unset, str] = UNSET
        if not isinstance(self.op_status, Unset):
            op_status = self.op_status.value

        message = self.message

        creator_id = self.creator_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if monitor_id is not UNSET:
            field_dict["monitor_id"] = monitor_id
        if status is not UNSET:
            field_dict["status"] = status
        if op_status is not UNSET:
            field_dict["op_status"] = op_status
        if message is not UNSET:
            field_dict["message"] = message
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        id = d.pop("id", UNSET)

        monitor_id = d.pop("monitor_id", UNSET)

        _status = d.pop("status", UNSET)
        status: Union[Unset, MonitorStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = MonitorStatus(_status)

        _op_status = d.pop("op_status", UNSET)
        op_status: Union[Unset, MonitorOpStatus]
        if isinstance(_op_status, Unset):
            op_status = UNSET
        else:
            op_status = MonitorOpStatus(_op_status)

        message = d.pop("message", UNSET)

        creator_id = d.pop("creator_id", UNSET)

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        monitor_log = cls(
            id=id,
            monitor_id=monitor_id,
            status=status,
            op_status=op_status,
            message=message,
            creator_id=creator_id,
            created_at=created_at,
        )

        monitor_log.additional_properties = d
        return monitor_log

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
