from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="StatsSummary")


@_attrs_define
class StatsSummary:
    """
    Attributes:
        grants_current (Union[Unset, int]): The number of currently active grants.
        grants_total (Union[Unset, int]): The total number of grants created and approved.
        claims_current (Union[Unset, int]): The number of currently active claims.
        claims_total (Union[Unset, int]): The total number of claims created and verified.
        radios_total (Union[Unset, int]): The total number of enabled radios.
        monitors_current (Union[Unset, int]): The number of currently active monitors.
        monitors_total (Union[Unset, int]): The total number of enabled monitors.
    """

    grants_current: Union[Unset, int] = UNSET
    grants_total: Union[Unset, int] = UNSET
    claims_current: Union[Unset, int] = UNSET
    claims_total: Union[Unset, int] = UNSET
    radios_total: Union[Unset, int] = UNSET
    monitors_current: Union[Unset, int] = UNSET
    monitors_total: Union[Unset, int] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "grants_current": {"put": None, "post": None},
        "grants_total": {"put": None, "post": None},
        "claims_current": {"put": None, "post": None},
        "claims_total": {"put": None, "post": None},
        "radios_total": {"put": None, "post": None},
        "monitors_current": {"put": None, "post": None},
        "monitors_total": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        grants_current = self.grants_current

        grants_total = self.grants_total

        claims_current = self.claims_current

        claims_total = self.claims_total

        radios_total = self.radios_total

        monitors_current = self.monitors_current

        monitors_total = self.monitors_total

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if grants_current is not UNSET:
            field_dict["grants_current"] = grants_current
        if grants_total is not UNSET:
            field_dict["grants_total"] = grants_total
        if claims_current is not UNSET:
            field_dict["claims_current"] = claims_current
        if claims_total is not UNSET:
            field_dict["claims_total"] = claims_total
        if radios_total is not UNSET:
            field_dict["radios_total"] = radios_total
        if monitors_current is not UNSET:
            field_dict["monitors_current"] = monitors_current
        if monitors_total is not UNSET:
            field_dict["monitors_total"] = monitors_total

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        grants_current = d.pop("grants_current", UNSET)

        grants_total = d.pop("grants_total", UNSET)

        claims_current = d.pop("claims_current", UNSET)

        claims_total = d.pop("claims_total", UNSET)

        radios_total = d.pop("radios_total", UNSET)

        monitors_current = d.pop("monitors_current", UNSET)

        monitors_total = d.pop("monitors_total", UNSET)

        stats_summary = cls(
            grants_current=grants_current,
            grants_total=grants_total,
            claims_current=claims_current,
            claims_total=claims_total,
            radios_total=radios_total,
            monitors_current=monitors_current,
            monitors_total=monitors_total,
        )

        stats_summary.additional_properties = d
        return stats_summary

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
