from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.policy import Policy


T = TypeVar("T", bound="PolicyList")


@_attrs_define
class PolicyList:
    """
    Attributes:
        policies (List['Policy']):
    """

    policies: List["Policy"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"policies": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        policies = []
        for policies_item_data in self.policies:
            policies_item = policies_item_data.to_dict()
            policies.append(policies_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "policies": policies,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.policy import Policy

        d = src_dict.copy()
        policies = []
        _policies = d.pop("policies")
        for policies_item_data in _policies:
            policies_item = Policy.from_dict(policies_item_data)

            policies.append(policies_item)

        policy_list = cls(
            policies=policies,
        )

        policy_list.additional_properties = d
        return policy_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.policy import Policy

    ns["Policy"] = Policy
