from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.monitor_task_state import MonitorTaskState


T = TypeVar("T", bound="MonitorTaskStateList")


@_attrs_define
class MonitorTaskStateList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        monitor_task_states (List['MonitorTaskState']):
    """

    page: int
    total: int
    pages: int
    monitor_task_states: List["MonitorTaskState"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        monitor_task_states = []
        for monitor_task_states_item_data in self.monitor_task_states:
            monitor_task_states_item = monitor_task_states_item_data.to_dict()
            monitor_task_states.append(monitor_task_states_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "monitor_task_states": monitor_task_states,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.monitor_task_state import MonitorTaskState

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        monitor_task_states = []
        _monitor_task_states = d.pop("monitor_task_states")
        for monitor_task_states_item_data in _monitor_task_states:
            monitor_task_states_item = MonitorTaskState.from_dict(
                monitor_task_states_item_data
            )

            monitor_task_states.append(monitor_task_states_item)

        monitor_task_state_list = cls(
            page=page,
            total=total,
            pages=pages,
            monitor_task_states=monitor_task_states,
        )

        monitor_task_state_list.additional_properties = d
        return monitor_task_state_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.monitor_task_state import MonitorTaskState

    ns["MonitorTaskState"] = MonitorTaskState
