from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.monitor_action import MonitorAction


T = TypeVar("T", bound="MonitorActionList")


@_attrs_define
class MonitorActionList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        monitor_actions (List['MonitorAction']):
    """

    page: int
    total: int
    pages: int
    monitor_actions: List["MonitorAction"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        monitor_actions = []
        for monitor_actions_item_data in self.monitor_actions:
            monitor_actions_item = monitor_actions_item_data.to_dict()
            monitor_actions.append(monitor_actions_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "monitor_actions": monitor_actions,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.monitor_action import MonitorAction

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        monitor_actions = []
        _monitor_actions = d.pop("monitor_actions")
        for monitor_actions_item_data in _monitor_actions:
            monitor_actions_item = MonitorAction.from_dict(monitor_actions_item_data)

            monitor_actions.append(monitor_actions_item)

        monitor_action_list = cls(
            page=page,
            total=total,
            pages=pages,
            monitor_actions=monitor_actions,
        )

        monitor_action_list.additional_properties = d
        return monitor_action_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.monitor_action import MonitorAction

    ns["MonitorAction"] = MonitorAction
