import functools
from typing import (
    Any,
    Callable,
    Concatenate,
    ParamSpec,
    TypeAlias,
    TypeVar,
    cast,
)

from .api.action.create_action import asyncio_detailed as create_action_asyncio_detailed
from .api.action.get_action import asyncio_detailed as get_action_asyncio_detailed
from .api.action.list_actions import asyncio_detailed as list_actions_asyncio_detailed
from .api.action.update_action import asyncio_detailed as update_action_asyncio_detailed
from .api.antenna.create_antenna import (
    asyncio_detailed as create_antenna_asyncio_detailed,
)
from .api.antenna.delete_antenna import (
    asyncio_detailed as delete_antenna_asyncio_detailed,
)
from .api.antenna.get_antenna import asyncio_detailed as get_antenna_asyncio_detailed
from .api.antenna.list_antennas import (
    asyncio_detailed as list_antennas_asyncio_detailed,
)
from .api.antenna.update_antenna import (
    asyncio_detailed as update_antenna_asyncio_detailed,
)
from .api.claim.create_claim import asyncio_detailed as create_claim_asyncio_detailed
from .api.claim.delete_claim import asyncio_detailed as delete_claim_asyncio_detailed
from .api.claim.get_claim import asyncio_detailed as get_claim_asyncio_detailed
from .api.claim.list_claims import asyncio_detailed as list_claims_asyncio_detailed
from .api.claim.update_claim import asyncio_detailed as update_claim_asyncio_detailed
from .api.grant.create_grant import asyncio_detailed as create_grant_asyncio_detailed
from .api.grant.create_grant_constraint import (
    asyncio_detailed as create_grant_constraint_asyncio_detailed,
)
from .api.grant.create_grant_int_constraint import (
    asyncio_detailed as create_grant_int_constraint_asyncio_detailed,
)
from .api.grant.create_grant_radio_port import (
    asyncio_detailed as create_grant_radio_port_asyncio_detailed,
)
from .api.grant.create_grant_replacement import (
    asyncio_detailed as create_grant_replacement_asyncio_detailed,
)
from .api.grant.create_grant_rt_int_constraint import (
    asyncio_detailed as create_grant_rt_int_constraint_asyncio_detailed,
)
from .api.grant.create_tardys_reservation import (
    asyncio_detailed as create_tardys_reservation_asyncio_detailed,
)
from .api.grant.delete_grant import asyncio_detailed as delete_grant_asyncio_detailed
from .api.grant.get_grant import asyncio_detailed as get_grant_asyncio_detailed
from .api.grant.list_grants import asyncio_detailed as list_grants_asyncio_detailed
from .api.grant.replace_grant import asyncio_detailed as replace_grant_asyncio_detailed
from .api.grant.update_grant import asyncio_detailed as update_grant_asyncio_detailed
from .api.grant.update_grant_op_status import (
    asyncio_detailed as update_grant_op_status_asyncio_detailed,
)
from .api.location.create_location import (
    asyncio_detailed as create_location_asyncio_detailed,
)
from .api.location.delete_location import (
    asyncio_detailed as delete_location_asyncio_detailed,
)
from .api.location.get_location import asyncio_detailed as get_location_asyncio_detailed
from .api.location.list_locations import (
    asyncio_detailed as list_locations_asyncio_detailed,
)
from .api.location.update_location import (
    asyncio_detailed as update_location_asyncio_detailed,
)
from .api.monitor.create_monitor import (
    asyncio_detailed as create_monitor_asyncio_detailed,
)
from .api.monitor.create_monitor_action import (
    asyncio_detailed as create_monitor_action_asyncio_detailed,
)
from .api.monitor.create_monitor_pending import (
    asyncio_detailed as create_monitor_pending_asyncio_detailed,
)
from .api.monitor.create_monitor_task import (
    asyncio_detailed as create_monitor_task_asyncio_detailed,
)
from .api.monitor.delete_action import (
    asyncio_detailed as delete_action_asyncio_detailed,
)
from .api.monitor.delete_monitor import (
    asyncio_detailed as delete_monitor_asyncio_detailed,
)
from .api.monitor.delete_monitor_action import (
    asyncio_detailed as delete_monitor_action_asyncio_detailed,
)
from .api.monitor.delete_monitor_pending import (
    asyncio_detailed as delete_monitor_pending_asyncio_detailed,
)
from .api.monitor.delete_monitor_task import (
    asyncio_detailed as delete_monitor_task_asyncio_detailed,
)
from .api.monitor.get_monitor import asyncio_detailed as get_monitor_asyncio_detailed
from .api.monitor.get_monitor_action import (
    asyncio_detailed as get_monitor_action_asyncio_detailed,
)
from .api.monitor.get_monitor_pending import (
    asyncio_detailed as get_monitor_pending_asyncio_detailed,
)
from .api.monitor.get_monitor_state import (
    asyncio_detailed as get_monitor_state_asyncio_detailed,
)
from .api.monitor.get_monitor_task import (
    asyncio_detailed as get_monitor_task_asyncio_detailed,
)
from .api.monitor.list_monitor_actions import (
    asyncio_detailed as list_monitor_actions_asyncio_detailed,
)
from .api.monitor.list_monitor_tasks import (
    asyncio_detailed as list_monitor_tasks_asyncio_detailed,
)
from .api.monitor.list_monitors import (
    asyncio_detailed as list_monitors_asyncio_detailed,
)
from .api.monitor.update_monitor import (
    asyncio_detailed as update_monitor_asyncio_detailed,
)
from .api.monitor.update_monitor_action import (
    asyncio_detailed as update_monitor_action_asyncio_detailed,
)
from .api.monitor.update_monitor_state import (
    asyncio_detailed as update_monitor_state_asyncio_detailed,
)
from .api.monitor.update_monitor_state_op_status import (
    asyncio_detailed as update_monitor_state_op_status_asyncio_detailed,
)
from .api.monitor.update_monitor_task_state import (
    asyncio_detailed as update_monitor_task_state_asyncio_detailed,
)
from .api.radio.create_radio import asyncio_detailed as create_radio_asyncio_detailed
from .api.radio.delete_radio import asyncio_detailed as delete_radio_asyncio_detailed
from .api.radio.get_radio import asyncio_detailed as get_radio_asyncio_detailed
from .api.radio.list_radios import asyncio_detailed as list_radios_asyncio_detailed
from .api.radio.update_radio import asyncio_detailed as update_radio_asyncio_detailed
from .api.radio_port.create_radio_port import (
    asyncio_detailed as create_radio_port_asyncio_detailed,
)
from .api.radio_port.delete_radio_port import (
    asyncio_detailed as delete_radio_port_asyncio_detailed,
)
from .api.radio_port.get_radio_port import (
    asyncio_detailed as get_radio_port_asyncio_detailed,
)
from .api.radio_port.list_radio_ports import (
    asyncio_detailed as list_radio_ports_asyncio_detailed,
)
from .api.radio_port.update_radio_port import (
    asyncio_detailed as update_radio_port_asyncio_detailed,
)
from .api.spectrum.create_spectrum import (
    asyncio_detailed as create_spectrum_asyncio_detailed,
)
from .api.spectrum.create_spectrum_constraint import (
    asyncio_detailed as create_spectrum_constraint_asyncio_detailed,
)
from .api.spectrum.create_spectrum_policy import (
    asyncio_detailed as create_spectrum_policy_asyncio_detailed,
)
from .api.spectrum.delete_spectrum import (
    asyncio_detailed as delete_spectrum_asyncio_detailed,
)
from .api.spectrum.delete_spectrum_constraint import (
    asyncio_detailed as delete_spectrum_constraint_asyncio_detailed,
)
from .api.spectrum.delete_spectrum_policy import (
    asyncio_detailed as delete_spectrum_policy_asyncio_detailed,
)
from .api.spectrum.get_spectrum import asyncio_detailed as get_spectrum_asyncio_detailed
from .api.spectrum.get_spectrum_constraint import (
    asyncio_detailed as get_spectrum_constraint_asyncio_detailed,
)
from .api.spectrum.get_spectrum_policy import (
    asyncio_detailed as get_spectrum_policy_asyncio_detailed,
)
from .api.spectrum.list_spectrum import (
    asyncio_detailed as list_spectrum_asyncio_detailed,
)
from .api.spectrum.update_spectrum import (
    asyncio_detailed as update_spectrum_asyncio_detailed,
)
from .api.spectrum.update_spectrum_constraint import (
    asyncio_detailed as update_spectrum_constraint_asyncio_detailed,
)
from .api.spectrum.update_spectrum_policy import (
    asyncio_detailed as update_spectrum_policy_asyncio_detailed,
)
from .api.stats.get_stats_summary import (
    asyncio_detailed as get_stats_summary_asyncio_detailed,
)
from .api.subscription.create_subscription import (
    asyncio_detailed as create_subscription_asyncio_detailed,
)
from .api.subscription.delete_subscription import (
    asyncio_detailed as delete_subscription_asyncio_detailed,
)
from .api.subscription.get_subscription_events import (
    asyncio_detailed as get_subscription_events_asyncio_detailed,
)
from .api.subscription.list_subscriptions import (
    asyncio_detailed as list_subscriptions_asyncio_detailed,
)
from .api.version.get_version import asyncio_detailed as get_version_asyncio_detailed
from .api.zone.list_zones import asyncio_detailed as list_zones_asyncio_detailed

T = TypeVar("T", bound=Callable[..., Any])
P = ParamSpec("P")
R = TypeVar("R")
MethodT: TypeAlias = Callable[Concatenate[Any, P], R]


def wraps_method(
    wrapped: MethodT[P, R],
    wrapper_name: str,
    **kwargs,
) -> Callable[[MethodT[P, R]], MethodT[P, R]]:
    def decorator(f: MethodT[P, R]) -> MethodT[P, R]:
        @functools.wraps(wrapped, **kwargs)
        def wrapper(self: Any, *args: P.args, **kwargs: P.kwargs) -> R:
            return f(self, *args, **kwargs)

        if wrapper_name:
            wrapper.__name__ = wrapper_name
        return cast(MethodT[P, R], wrapper)

    return decorator


class ClientApiAsyncioMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(self, *args, **kwargs, client=self)

    @wraps_method(get_version_asyncio_detailed, "get_version")  # type: ignore
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_stats_summary_asyncio_detailed, "get_stats_summary")  # type: ignore
    def get_stats_summary(self, *args, **kwargs):
        return self._call_api_func(get_stats_summary_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_zones_asyncio_detailed, "list_zones")  # type: ignore
    def list_zones(self, *args, **kwargs):
        return self._call_api_func(list_zones_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_spectrum_asyncio_detailed, "list_spectrum")  # type: ignore
    def list_spectrum(self, *args, **kwargs):
        return self._call_api_func(list_spectrum_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_spectrum_asyncio_detailed, "create_spectrum")  # type: ignore
    def create_spectrum(self, *args, **kwargs):
        return self._call_api_func(create_spectrum_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_spectrum_asyncio_detailed, "get_spectrum")  # type: ignore
    def get_spectrum(self, *args, **kwargs):
        return self._call_api_func(get_spectrum_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_spectrum_asyncio_detailed, "update_spectrum")  # type: ignore
    def update_spectrum(self, *args, **kwargs):
        return self._call_api_func(update_spectrum_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_spectrum_asyncio_detailed, "delete_spectrum")  # type: ignore
    def delete_spectrum(self, *args, **kwargs):
        return self._call_api_func(delete_spectrum_asyncio_detailed, *args, **kwargs)

    @wraps_method(
        create_spectrum_constraint_asyncio_detailed, "create_spectrum_constraint"
    )  # type: ignore
    def create_spectrum_constraint(self, *args, **kwargs):
        return self._call_api_func(
            create_spectrum_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_spectrum_constraint_asyncio_detailed, "get_spectrum_constraint")  # type: ignore
    def get_spectrum_constraint(self, *args, **kwargs):
        return self._call_api_func(
            get_spectrum_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        update_spectrum_constraint_asyncio_detailed, "update_spectrum_constraint"
    )  # type: ignore
    def update_spectrum_constraint(self, *args, **kwargs):
        return self._call_api_func(
            update_spectrum_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        delete_spectrum_constraint_asyncio_detailed, "delete_spectrum_constraint"
    )  # type: ignore
    def delete_spectrum_constraint(self, *args, **kwargs):
        return self._call_api_func(
            delete_spectrum_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(create_spectrum_policy_asyncio_detailed, "create_spectrum_policy")  # type: ignore
    def create_spectrum_policy(self, *args, **kwargs):
        return self._call_api_func(
            create_spectrum_policy_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_spectrum_policy_asyncio_detailed, "get_spectrum_policy")  # type: ignore
    def get_spectrum_policy(self, *args, **kwargs):
        return self._call_api_func(
            get_spectrum_policy_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(update_spectrum_policy_asyncio_detailed, "update_spectrum_policy")  # type: ignore
    def update_spectrum_policy(self, *args, **kwargs):
        return self._call_api_func(
            update_spectrum_policy_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_spectrum_policy_asyncio_detailed, "delete_spectrum_policy")  # type: ignore
    def delete_spectrum_policy(self, *args, **kwargs):
        return self._call_api_func(
            delete_spectrum_policy_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_locations_asyncio_detailed, "list_locations")  # type: ignore
    def list_locations(self, *args, **kwargs):
        return self._call_api_func(list_locations_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_location_asyncio_detailed, "create_location")  # type: ignore
    def create_location(self, *args, **kwargs):
        return self._call_api_func(create_location_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_location_asyncio_detailed, "get_location")  # type: ignore
    def get_location(self, *args, **kwargs):
        return self._call_api_func(get_location_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_location_asyncio_detailed, "update_location")  # type: ignore
    def update_location(self, *args, **kwargs):
        return self._call_api_func(update_location_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_location_asyncio_detailed, "delete_location")  # type: ignore
    def delete_location(self, *args, **kwargs):
        return self._call_api_func(delete_location_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_radios_asyncio_detailed, "list_radios")  # type: ignore
    def list_radios(self, *args, **kwargs):
        return self._call_api_func(list_radios_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_radio_asyncio_detailed, "create_radio")  # type: ignore
    def create_radio(self, *args, **kwargs):
        return self._call_api_func(create_radio_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_radio_asyncio_detailed, "get_radio")  # type: ignore
    def get_radio(self, *args, **kwargs):
        return self._call_api_func(get_radio_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_radio_asyncio_detailed, "update_radio")  # type: ignore
    def update_radio(self, *args, **kwargs):
        return self._call_api_func(update_radio_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_radio_asyncio_detailed, "delete_radio")  # type: ignore
    def delete_radio(self, *args, **kwargs):
        return self._call_api_func(delete_radio_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_radio_ports_asyncio_detailed, "list_radio_ports")  # type: ignore
    def list_radio_ports(self, *args, **kwargs):
        return self._call_api_func(list_radio_ports_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_radio_port_asyncio_detailed, "create_radio_port")  # type: ignore
    def create_radio_port(self, *args, **kwargs):
        return self._call_api_func(create_radio_port_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_radio_port_asyncio_detailed, "get_radio_port")  # type: ignore
    def get_radio_port(self, *args, **kwargs):
        return self._call_api_func(get_radio_port_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_radio_port_asyncio_detailed, "update_radio_port")  # type: ignore
    def update_radio_port(self, *args, **kwargs):
        return self._call_api_func(update_radio_port_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_radio_port_asyncio_detailed, "delete_radio_port")  # type: ignore
    def delete_radio_port(self, *args, **kwargs):
        return self._call_api_func(delete_radio_port_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_antennas_asyncio_detailed, "list_antennas")  # type: ignore
    def list_antennas(self, *args, **kwargs):
        return self._call_api_func(list_antennas_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_antenna_asyncio_detailed, "create_antenna")  # type: ignore
    def create_antenna(self, *args, **kwargs):
        return self._call_api_func(create_antenna_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_antenna_asyncio_detailed, "get_antenna")  # type: ignore
    def get_antenna(self, *args, **kwargs):
        return self._call_api_func(get_antenna_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_antenna_asyncio_detailed, "update_antenna")  # type: ignore
    def update_antenna(self, *args, **kwargs):
        return self._call_api_func(update_antenna_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_antenna_asyncio_detailed, "delete_antenna")  # type: ignore
    def delete_antenna(self, *args, **kwargs):
        return self._call_api_func(delete_antenna_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_grants_asyncio_detailed, "list_grants")  # type: ignore
    def list_grants(self, *args, **kwargs):
        return self._call_api_func(list_grants_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_grant_asyncio_detailed, "create_grant")  # type: ignore
    def create_grant(self, *args, **kwargs):
        return self._call_api_func(create_grant_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_grant_asyncio_detailed, "get_grant")  # type: ignore
    def get_grant(self, *args, **kwargs):
        return self._call_api_func(get_grant_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_grant_asyncio_detailed, "update_grant")  # type: ignore
    def update_grant(self, *args, **kwargs):
        return self._call_api_func(update_grant_asyncio_detailed, *args, **kwargs)

    @wraps_method(replace_grant_asyncio_detailed, "replace_grant")  # type: ignore
    def replace_grant(self, *args, **kwargs):
        return self._call_api_func(replace_grant_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_grant_asyncio_detailed, "delete_grant")  # type: ignore
    def delete_grant(self, *args, **kwargs):
        return self._call_api_func(delete_grant_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_grant_replacement_asyncio_detailed, "create_grant_replacement")  # type: ignore
    def create_grant_replacement(self, *args, **kwargs):
        return self._call_api_func(
            create_grant_replacement_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(create_grant_radio_port_asyncio_detailed, "create_grant_radio_port")  # type: ignore
    def create_grant_radio_port(self, *args, **kwargs):
        return self._call_api_func(
            create_grant_radio_port_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(create_grant_constraint_asyncio_detailed, "create_grant_constraint")  # type: ignore
    def create_grant_constraint(self, *args, **kwargs):
        return self._call_api_func(
            create_grant_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        create_grant_int_constraint_asyncio_detailed, "create_grant_int_constraint"
    )  # type: ignore
    def create_grant_int_constraint(self, *args, **kwargs):
        return self._call_api_func(
            create_grant_int_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        create_grant_rt_int_constraint_asyncio_detailed,
        "create_grant_rt_int_constraint",
    )  # type: ignore
    def create_grant_rt_int_constraint(self, *args, **kwargs):
        return self._call_api_func(
            create_grant_rt_int_constraint_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(update_grant_op_status_asyncio_detailed, "update_grant_op_status")  # type: ignore
    def update_grant_op_status(self, *args, **kwargs):
        return self._call_api_func(
            update_grant_op_status_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        create_tardys_reservation_asyncio_detailed, "create_tardys_reservation"
    )  # type: ignore
    def create_tardys_reservation(self, *args, **kwargs):
        return self._call_api_func(
            create_tardys_reservation_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_claims_asyncio_detailed, "list_claims")  # type: ignore
    def list_claims(self, *args, **kwargs):
        return self._call_api_func(list_claims_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_claim_asyncio_detailed, "create_claim")  # type: ignore
    def create_claim(self, *args, **kwargs):
        return self._call_api_func(create_claim_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_claim_asyncio_detailed, "get_claim")  # type: ignore
    def get_claim(self, *args, **kwargs):
        return self._call_api_func(get_claim_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_claim_asyncio_detailed, "update_claim")  # type: ignore
    def update_claim(self, *args, **kwargs):
        return self._call_api_func(update_claim_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_claim_asyncio_detailed, "delete_claim")  # type: ignore
    def delete_claim(self, *args, **kwargs):
        return self._call_api_func(delete_claim_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_monitors_asyncio_detailed, "list_monitors")  # type: ignore
    def list_monitors(self, *args, **kwargs):
        return self._call_api_func(list_monitors_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_monitor_asyncio_detailed, "create_monitor")  # type: ignore
    def create_monitor(self, *args, **kwargs):
        return self._call_api_func(create_monitor_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_monitor_asyncio_detailed, "get_monitor")  # type: ignore
    def get_monitor(self, *args, **kwargs):
        return self._call_api_func(get_monitor_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_monitor_asyncio_detailed, "update_monitor")  # type: ignore
    def update_monitor(self, *args, **kwargs):
        return self._call_api_func(update_monitor_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_monitor_asyncio_detailed, "delete_monitor")  # type: ignore
    def delete_monitor(self, *args, **kwargs):
        return self._call_api_func(delete_monitor_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_monitor_state_asyncio_detailed, "get_monitor_state")  # type: ignore
    def get_monitor_state(self, *args, **kwargs):
        return self._call_api_func(get_monitor_state_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_monitor_state_asyncio_detailed, "update_monitor_state")  # type: ignore
    def update_monitor_state(self, *args, **kwargs):
        return self._call_api_func(
            update_monitor_state_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        update_monitor_state_op_status_asyncio_detailed,
        "update_monitor_state_op_status",
    )  # type: ignore
    def update_monitor_state_op_status(self, *args, **kwargs):
        return self._call_api_func(
            update_monitor_state_op_status_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_monitor_pending_asyncio_detailed, "get_monitor_pending")  # type: ignore
    def get_monitor_pending(self, *args, **kwargs):
        return self._call_api_func(
            get_monitor_pending_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(create_monitor_pending_asyncio_detailed, "create_monitor_pending")  # type: ignore
    def create_monitor_pending(self, *args, **kwargs):
        return self._call_api_func(
            create_monitor_pending_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_monitor_pending_asyncio_detailed, "delete_monitor_pending")  # type: ignore
    def delete_monitor_pending(self, *args, **kwargs):
        return self._call_api_func(
            delete_monitor_pending_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_action_asyncio_detailed, "delete_action")  # type: ignore
    def delete_action(self, *args, **kwargs):
        return self._call_api_func(delete_action_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_monitor_actions_asyncio_detailed, "list_monitor_actions")  # type: ignore
    def list_monitor_actions(self, *args, **kwargs):
        return self._call_api_func(
            list_monitor_actions_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(create_monitor_action_asyncio_detailed, "create_monitor_action")  # type: ignore
    def create_monitor_action(self, *args, **kwargs):
        return self._call_api_func(
            create_monitor_action_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_monitor_action_asyncio_detailed, "get_monitor_action")  # type: ignore
    def get_monitor_action(self, *args, **kwargs):
        return self._call_api_func(get_monitor_action_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_monitor_action_asyncio_detailed, "update_monitor_action")  # type: ignore
    def update_monitor_action(self, *args, **kwargs):
        return self._call_api_func(
            update_monitor_action_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_monitor_action_asyncio_detailed, "delete_monitor_action")  # type: ignore
    def delete_monitor_action(self, *args, **kwargs):
        return self._call_api_func(
            delete_monitor_action_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_monitor_tasks_asyncio_detailed, "list_monitor_tasks")  # type: ignore
    def list_monitor_tasks(self, *args, **kwargs):
        return self._call_api_func(list_monitor_tasks_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_monitor_task_asyncio_detailed, "create_monitor_task")  # type: ignore
    def create_monitor_task(self, *args, **kwargs):
        return self._call_api_func(
            create_monitor_task_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_monitor_task_asyncio_detailed, "get_monitor_task")  # type: ignore
    def get_monitor_task(self, *args, **kwargs):
        return self._call_api_func(get_monitor_task_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_monitor_task_asyncio_detailed, "delete_monitor_task")  # type: ignore
    def delete_monitor_task(self, *args, **kwargs):
        return self._call_api_func(
            delete_monitor_task_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        update_monitor_task_state_asyncio_detailed, "update_monitor_task_state"
    )  # type: ignore
    def update_monitor_task_state(self, *args, **kwargs):
        return self._call_api_func(
            update_monitor_task_state_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_actions_asyncio_detailed, "list_actions")  # type: ignore
    def list_actions(self, *args, **kwargs):
        return self._call_api_func(list_actions_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_action_asyncio_detailed, "create_action")  # type: ignore
    def create_action(self, *args, **kwargs):
        return self._call_api_func(create_action_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_action_asyncio_detailed, "get_action")  # type: ignore
    def get_action(self, *args, **kwargs):
        return self._call_api_func(get_action_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_action_asyncio_detailed, "update_action")  # type: ignore
    def update_action(self, *args, **kwargs):
        return self._call_api_func(update_action_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_subscriptions_asyncio_detailed, "list_subscriptions")  # type: ignore
    def list_subscriptions(self, *args, **kwargs):
        return self._call_api_func(list_subscriptions_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_subscription_asyncio_detailed, "create_subscription")  # type: ignore
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(
            create_subscription_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_subscription_asyncio_detailed, "delete_subscription")  # type: ignore
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(
            delete_subscription_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_subscription_events_asyncio_detailed, "get_subscription_events")  # type: ignore
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_asyncio_detailed, *args, **kwargs
        )
