from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_radio_ports_sort import ListRadioPortsSort
from ...models.radio_port_list import RadioPortList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    radio_id: str,
    *,
    tx: Union[Unset, bool] = UNSET,
    rx: Union[Unset, bool] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListRadioPortsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["tx"] = tx

    params["rx"] = rx

    params["enabled"] = enabled

    params["deleted"] = deleted

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/radios/{radio_id}/ports".format(
            radio_id=radio_id,
        ),
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, RadioPortList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = RadioPortList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, RadioPortList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    client: AuthenticatedClient,
    radio_id: str,
    *,
    tx: Union[Unset, bool] = UNSET,
    rx: Union[Unset, bool] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListRadioPortsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, RadioPortList]]:
    """Retrieve a list of radio ports.

    Args:
        radio_id (str): The target radio.
        tx (Union[Unset, bool]): If not present, unfiltered on tx; if true, show transmitters; if
            false, exclude transmitters.
        rx (Union[Unset, bool]): If not present, unfiltered on rx; if true, show receivers; if
            false, exclude receivers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radio ports; if
            `false`, show disabled radio ports.
        deleted (Union[Unset, bool]): If true, show only deleted radio ports. Default: False.
        sort (Union[Unset, ListRadioPortsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, RadioPortList]]
    """

    kwargs = _get_kwargs(
        radio_id=radio_id,
        tx=tx,
        rx=rx,
        enabled=enabled,
        deleted=deleted,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    client: AuthenticatedClient,
    radio_id: str,
    *,
    tx: Union[Unset, bool] = UNSET,
    rx: Union[Unset, bool] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListRadioPortsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, RadioPortList]]:
    """Retrieve a list of radio ports.

    Args:
        radio_id (str): The target radio.
        tx (Union[Unset, bool]): If not present, unfiltered on tx; if true, show transmitters; if
            false, exclude transmitters.
        rx (Union[Unset, bool]): If not present, unfiltered on rx; if true, show receivers; if
            false, exclude receivers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radio ports; if
            `false`, show disabled radio ports.
        deleted (Union[Unset, bool]): If true, show only deleted radio ports. Default: False.
        sort (Union[Unset, ListRadioPortsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, RadioPortList]
    """

    return sync_detailed(
        radio_id=radio_id,
        client=client,
        tx=tx,
        rx=rx,
        enabled=enabled,
        deleted=deleted,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    client: AuthenticatedClient,
    radio_id: str,
    *,
    tx: Union[Unset, bool] = UNSET,
    rx: Union[Unset, bool] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListRadioPortsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, RadioPortList]]:
    """Retrieve a list of radio ports.

    Args:
        radio_id (str): The target radio.
        tx (Union[Unset, bool]): If not present, unfiltered on tx; if true, show transmitters; if
            false, exclude transmitters.
        rx (Union[Unset, bool]): If not present, unfiltered on rx; if true, show receivers; if
            false, exclude receivers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radio ports; if
            `false`, show disabled radio ports.
        deleted (Union[Unset, bool]): If true, show only deleted radio ports. Default: False.
        sort (Union[Unset, ListRadioPortsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, RadioPortList]]
    """

    kwargs = _get_kwargs(
        radio_id=radio_id,
        tx=tx,
        rx=rx,
        enabled=enabled,
        deleted=deleted,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    client: AuthenticatedClient,
    radio_id: str,
    *,
    tx: Union[Unset, bool] = UNSET,
    rx: Union[Unset, bool] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListRadioPortsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, RadioPortList]]:
    """Retrieve a list of radio ports.

    Args:
        radio_id (str): The target radio.
        tx (Union[Unset, bool]): If not present, unfiltered on tx; if true, show transmitters; if
            false, exclude transmitters.
        rx (Union[Unset, bool]): If not present, unfiltered on rx; if true, show receivers; if
            false, exclude receivers.
        enabled (Union[Unset, bool]): If omitted or `true`, show only enabled radio ports; if
            `false`, show disabled radio ports.
        deleted (Union[Unset, bool]): If true, show only deleted radio ports. Default: False.
        sort (Union[Unset, ListRadioPortsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, RadioPortList]
    """

    return (
        await asyncio_detailed(
            radio_id=radio_id,
            client=client,
            tx=tx,
            rx=rx,
            enabled=enabled,
            deleted=deleted,
            sort=sort,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
