from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="StatsSummary")


@_attrs_define
class StatsSummary:
    """
    Attributes:
        total_users (Union[Unset, int]): Total number of users in the system.
        total_elements (Union[Unset, int]): Total number of elements in the system.
    """

    total_users: Union[Unset, int] = UNSET
    total_elements: Union[Unset, int] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "total_users": {"put": None, "post": None},
        "total_elements": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        total_users = self.total_users

        total_elements = self.total_elements

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if total_users is not UNSET:
            field_dict["total_users"] = total_users
        if total_elements is not UNSET:
            field_dict["total_elements"] = total_elements

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        total_users = d.pop("total_users", UNSET)

        total_elements = d.pop("total_elements", UNSET)

        stats_summary = cls(
            total_users=total_users,
            total_elements=total_elements,
        )

        stats_summary.additional_properties = d
        return stats_summary

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
