from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.role_binding import RoleBinding


T = TypeVar("T", bound="RoleBindingList")


@_attrs_define
class RoleBindingList:
    """A list of role bindings.

    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        role_bindings (List['RoleBinding']):
    """

    page: int
    total: int
    pages: int
    role_bindings: List["RoleBinding"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        role_bindings = []
        for role_bindings_item_data in self.role_bindings:
            role_bindings_item = role_bindings_item_data.to_dict()
            role_bindings.append(role_bindings_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "role_bindings": role_bindings,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.role_binding import RoleBinding

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        role_bindings = []
        _role_bindings = d.pop("role_bindings")
        for role_bindings_item_data in _role_bindings:
            role_bindings_item = RoleBinding.from_dict(role_bindings_item_data)

            role_bindings.append(role_bindings_item)

        role_binding_list = cls(
            page=page,
            total=total,
            pages=pages,
            role_bindings=role_bindings,
        )

        role_binding_list.additional_properties = d
        return role_binding_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.role_binding import RoleBinding

    ns["RoleBinding"] = RoleBinding
