import functools
from typing import (
    Any,
    Callable,
    Concatenate,
    ParamSpec,
    TypeAlias,
    TypeVar,
    cast,
)

from .api.element.create_element import (
    asyncio_detailed as create_element_asyncio_detailed,
)
from .api.element.delete_element import (
    asyncio_detailed as delete_element_asyncio_detailed,
)
from .api.element.get_element import asyncio_detailed as get_element_asyncio_detailed
from .api.element.list_elements import (
    asyncio_detailed as list_elements_asyncio_detailed,
)
from .api.element.update_element import (
    asyncio_detailed as update_element_asyncio_detailed,
)
from .api.role.list_roles import asyncio_detailed as list_roles_asyncio_detailed
from .api.role_binding.create_role_binding import (
    asyncio_detailed as create_role_binding_asyncio_detailed,
)
from .api.role_binding.delete_role_binding import (
    asyncio_detailed as delete_role_binding_asyncio_detailed,
)
from .api.role_binding.get_role_binding import (
    asyncio_detailed as get_role_binding_asyncio_detailed,
)
from .api.role_binding.list_role_bindings import (
    asyncio_detailed as list_role_bindings_asyncio_detailed,
)
from .api.role_binding.update_role_binding import (
    asyncio_detailed as update_role_binding_asyncio_detailed,
)
from .api.service.list_services import (
    asyncio_detailed as list_services_asyncio_detailed,
)
from .api.stats.get_stats_summary import (
    asyncio_detailed as get_stats_summary_asyncio_detailed,
)
from .api.subscription.create_subscription import (
    asyncio_detailed as create_subscription_asyncio_detailed,
)
from .api.subscription.delete_subscription import (
    asyncio_detailed as delete_subscription_asyncio_detailed,
)
from .api.subscription.get_subscription_events import (
    asyncio_detailed as get_subscription_events_asyncio_detailed,
)
from .api.subscription.get_subscriptions import (
    asyncio_detailed as get_subscriptions_asyncio_detailed,
)
from .api.token.create_token import asyncio_detailed as create_token_asyncio_detailed
from .api.token.delete_token import asyncio_detailed as delete_token_asyncio_detailed
from .api.token.delete_token_this import (
    asyncio_detailed as delete_token_this_asyncio_detailed,
)
from .api.token.get_token import asyncio_detailed as get_token_asyncio_detailed
from .api.token.get_token_this import (
    asyncio_detailed as get_token_this_asyncio_detailed,
)
from .api.user.create_user import asyncio_detailed as create_user_asyncio_detailed
from .api.user.delete_user import asyncio_detailed as delete_user_asyncio_detailed
from .api.user.get_user import asyncio_detailed as get_user_asyncio_detailed
from .api.user.list_user_elements import (
    asyncio_detailed as list_user_elements_asyncio_detailed,
)
from .api.user.list_user_role_bindings import (
    asyncio_detailed as list_user_role_bindings_asyncio_detailed,
)
from .api.user.list_user_tokens import (
    asyncio_detailed as list_user_tokens_asyncio_detailed,
)
from .api.user.list_users import asyncio_detailed as list_users_asyncio_detailed
from .api.user.update_user import asyncio_detailed as update_user_asyncio_detailed
from .api.version.get_version import asyncio_detailed as get_version_asyncio_detailed

T = TypeVar("T", bound=Callable[..., Any])
P = ParamSpec("P")
R = TypeVar("R")
MethodT: TypeAlias = Callable[Concatenate[Any, P], R]


def wraps_method(
    wrapped: MethodT[P, R],
    wrapper_name: str,
    **kwargs,
) -> Callable[[MethodT[P, R]], MethodT[P, R]]:
    def decorator(f: MethodT[P, R]) -> MethodT[P, R]:
        @functools.wraps(wrapped, **kwargs)
        def wrapper(self: Any, *args: P.args, **kwargs: P.kwargs) -> R:
            return f(self, *args, **kwargs)

        if wrapper_name:
            wrapper.__name__ = wrapper_name
        return cast(MethodT[P, R], wrapper)

    return decorator


class ClientApiAsyncioMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(self, *args, **kwargs, client=self)

    @wraps_method(get_version_asyncio_detailed, "get_version")  # type: ignore
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_stats_summary_asyncio_detailed, "get_stats_summary")  # type: ignore
    def get_stats_summary(self, *args, **kwargs):
        return self._call_api_func(get_stats_summary_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_token_asyncio_detailed, "create_token")  # type: ignore
    def create_token(self, *args, **kwargs):
        return self._call_api_func(create_token_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_token_this_asyncio_detailed, "delete_token_this")  # type: ignore
    def delete_token_this(self, *args, **kwargs):
        return self._call_api_func(delete_token_this_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_token_this_asyncio_detailed, "get_token_this")  # type: ignore
    def get_token_this(self, *args, **kwargs):
        return self._call_api_func(get_token_this_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_token_asyncio_detailed, "get_token")  # type: ignore
    def get_token(self, *args, **kwargs):
        return self._call_api_func(get_token_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_token_asyncio_detailed, "delete_token")  # type: ignore
    def delete_token(self, *args, **kwargs):
        return self._call_api_func(delete_token_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_role_bindings_asyncio_detailed, "list_role_bindings")  # type: ignore
    def list_role_bindings(self, *args, **kwargs):
        return self._call_api_func(list_role_bindings_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_role_binding_asyncio_detailed, "create_role_binding")  # type: ignore
    def create_role_binding(self, *args, **kwargs):
        return self._call_api_func(
            create_role_binding_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_role_binding_asyncio_detailed, "get_role_binding")  # type: ignore
    def get_role_binding(self, *args, **kwargs):
        return self._call_api_func(get_role_binding_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_role_binding_asyncio_detailed, "update_role_binding")  # type: ignore
    def update_role_binding(self, *args, **kwargs):
        return self._call_api_func(
            update_role_binding_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_role_binding_asyncio_detailed, "delete_role_binding")  # type: ignore
    def delete_role_binding(self, *args, **kwargs):
        return self._call_api_func(
            delete_role_binding_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_elements_asyncio_detailed, "list_elements")  # type: ignore
    def list_elements(self, *args, **kwargs):
        return self._call_api_func(list_elements_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_element_asyncio_detailed, "create_element")  # type: ignore
    def create_element(self, *args, **kwargs):
        return self._call_api_func(create_element_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_element_asyncio_detailed, "get_element")  # type: ignore
    def get_element(self, *args, **kwargs):
        return self._call_api_func(get_element_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_element_asyncio_detailed, "update_element")  # type: ignore
    def update_element(self, *args, **kwargs):
        return self._call_api_func(update_element_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_element_asyncio_detailed, "delete_element")  # type: ignore
    def delete_element(self, *args, **kwargs):
        return self._call_api_func(delete_element_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_users_asyncio_detailed, "list_users")  # type: ignore
    def list_users(self, *args, **kwargs):
        return self._call_api_func(list_users_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_user_asyncio_detailed, "create_user")  # type: ignore
    def create_user(self, *args, **kwargs):
        return self._call_api_func(create_user_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_user_asyncio_detailed, "get_user")  # type: ignore
    def get_user(self, *args, **kwargs):
        return self._call_api_func(get_user_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_user_asyncio_detailed, "update_user")  # type: ignore
    def update_user(self, *args, **kwargs):
        return self._call_api_func(update_user_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_user_asyncio_detailed, "delete_user")  # type: ignore
    def delete_user(self, *args, **kwargs):
        return self._call_api_func(delete_user_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_user_tokens_asyncio_detailed, "list_user_tokens")  # type: ignore
    def list_user_tokens(self, *args, **kwargs):
        return self._call_api_func(list_user_tokens_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_user_elements_asyncio_detailed, "list_user_elements")  # type: ignore
    def list_user_elements(self, *args, **kwargs):
        return self._call_api_func(list_user_elements_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_user_role_bindings_asyncio_detailed, "list_user_role_bindings")  # type: ignore
    def list_user_role_bindings(self, *args, **kwargs):
        return self._call_api_func(
            list_user_role_bindings_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_services_asyncio_detailed, "list_services")  # type: ignore
    def list_services(self, *args, **kwargs):
        return self._call_api_func(list_services_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_roles_asyncio_detailed, "list_roles")  # type: ignore
    def list_roles(self, *args, **kwargs):
        return self._call_api_func(list_roles_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_subscriptions_asyncio_detailed, "get_subscriptions")  # type: ignore
    def get_subscriptions(self, *args, **kwargs):
        return self._call_api_func(get_subscriptions_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_subscription_asyncio_detailed, "create_subscription")  # type: ignore
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(
            create_subscription_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_subscription_asyncio_detailed, "delete_subscription")  # type: ignore
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(
            delete_subscription_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_subscription_events_asyncio_detailed, "get_subscription_events")  # type: ignore
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_asyncio_detailed, *args, **kwargs
        )
