import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.element_list import ElementList
from ...models.error import Error
from ...models.list_elements_end_field import ListElementsEndField
from ...models.list_elements_kind import ListElementsKind
from ...models.list_elements_sort import ListElementsSort
from ...models.list_elements_start_field import ListElementsStartField
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    element: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListElementsSort] = UNSET,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListElementsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListElementsEndField] = UNSET,
    kind: Union[Unset, ListElementsKind] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["element"] = element

    params["enabled"] = enabled

    params["deleted"] = deleted

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["include_deleted"] = include_deleted

    json_include_deleted_after: Union[Unset, str] = UNSET
    if not isinstance(include_deleted_after, Unset):
        json_include_deleted_after = include_deleted_after.isoformat()
    params["include_deleted_after"] = json_include_deleted_after

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/elements",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[ElementList, Error]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = ElementList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[ElementList, Error]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    client: AuthenticatedClient,
    *,
    element: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListElementsSort] = UNSET,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListElementsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListElementsEndField] = UNSET,
    kind: Union[Unset, ListElementsKind] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[ElementList, Error]]:
    """Retrieve a list of elements.

    Args:
        element (Union[Unset, str]): Filters elements by this value in field contents (fields
            `name`, `html_url`, `description`).
        enabled (Union[Unset, bool]): If set `true`, shows only `enabled` elements; if set
            `false`, shows only `disabled` elements.
        deleted (Union[Unset, bool]): If omitted or false, show only deleted elements.  If true,
            show only deleted elements. Default: False.
        sort (Union[Unset, ListElementsSort]): Sorts by specified field.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListElementsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListElementsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListElementsKind]):
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[ElementList, Error]]
    """

    kwargs = _get_kwargs(
        element=element,
        enabled=enabled,
        deleted=deleted,
        sort=sort,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    client: AuthenticatedClient,
    *,
    element: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListElementsSort] = UNSET,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListElementsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListElementsEndField] = UNSET,
    kind: Union[Unset, ListElementsKind] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[ElementList, Error]]:
    """Retrieve a list of elements.

    Args:
        element (Union[Unset, str]): Filters elements by this value in field contents (fields
            `name`, `html_url`, `description`).
        enabled (Union[Unset, bool]): If set `true`, shows only `enabled` elements; if set
            `false`, shows only `disabled` elements.
        deleted (Union[Unset, bool]): If omitted or false, show only deleted elements.  If true,
            show only deleted elements. Default: False.
        sort (Union[Unset, ListElementsSort]): Sorts by specified field.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListElementsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListElementsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListElementsKind]):
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[ElementList, Error]
    """

    return sync_detailed(
        client=client,
        element=element,
        enabled=enabled,
        deleted=deleted,
        sort=sort,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    client: AuthenticatedClient,
    *,
    element: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListElementsSort] = UNSET,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListElementsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListElementsEndField] = UNSET,
    kind: Union[Unset, ListElementsKind] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[ElementList, Error]]:
    """Retrieve a list of elements.

    Args:
        element (Union[Unset, str]): Filters elements by this value in field contents (fields
            `name`, `html_url`, `description`).
        enabled (Union[Unset, bool]): If set `true`, shows only `enabled` elements; if set
            `false`, shows only `disabled` elements.
        deleted (Union[Unset, bool]): If omitted or false, show only deleted elements.  If true,
            show only deleted elements. Default: False.
        sort (Union[Unset, ListElementsSort]): Sorts by specified field.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListElementsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListElementsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListElementsKind]):
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[ElementList, Error]]
    """

    kwargs = _get_kwargs(
        element=element,
        enabled=enabled,
        deleted=deleted,
        sort=sort,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    client: AuthenticatedClient,
    *,
    element: Union[Unset, str] = UNSET,
    enabled: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListElementsSort] = UNSET,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListElementsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListElementsEndField] = UNSET,
    kind: Union[Unset, ListElementsKind] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[ElementList, Error]]:
    """Retrieve a list of elements.

    Args:
        element (Union[Unset, str]): Filters elements by this value in field contents (fields
            `name`, `html_url`, `description`).
        enabled (Union[Unset, bool]): If set `true`, shows only `enabled` elements; if set
            `false`, shows only `disabled` elements.
        deleted (Union[Unset, bool]): If omitted or false, show only deleted elements.  If true,
            show only deleted elements. Default: False.
        sort (Union[Unset, ListElementsSort]): Sorts by specified field.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListElementsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListElementsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListElementsKind]):
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[ElementList, Error]
    """

    return (
        await asyncio_detailed(
            client=client,
            element=element,
            enabled=enabled,
            deleted=deleted,
            sort=sort,
            include_deleted=include_deleted,
            include_deleted_after=include_deleted_after,
            start=start,
            start_field=start_field,
            end=end,
            end_field=end_field,
            kind=kind,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
