import datetime
from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.any_object import AnyObject


T = TypeVar("T", bound="Value")


@_attrs_define
class Value:
    """Value reported from a monitor.

    Attributes:
        monitor_id (str): The monitor id that reported the value.
        id (Union[Unset, str]): The id of the value.
        series_id (Union[Unset, str]): The series id in which this value belongs.
        metric_id (Union[Unset, str]): The metric id associated with this value.
        observation_id (Union[None, Unset, str]): The observation id this value is associated with, if any.
        value (Union[None, Unset, float]): The value as a float, unless multi-valued.
        fields (Union[None, Unset, AnyObject]):
        tags (Union[None, Unset, AnyObject]):
        creator_id (Union[Unset, str]): The user id of the creator.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
    """

    monitor_id: str
    id: Union[Unset, str] = UNSET
    series_id: Union[Unset, str] = UNSET
    metric_id: Union[Unset, str] = UNSET
    observation_id: Union[None, Unset, str] = UNSET
    value: Union[None, Unset, float] = UNSET
    fields: Union[None, Unset, "AnyObject"] = UNSET
    tags: Union[None, Unset, "AnyObject"] = UNSET
    creator_id: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "series_id": {"put": True, "post": None},
        "metric_id": {"put": True, "post": None},
        "monitor_id": {"put": True, "post": None},
        "observation_id": {"put": True, "post": None},
        "value": {"put": True, "post": None},
        "fields": {"put": True, "post": None},
        "tags": {"put": True, "post": None},
        "creator_id": {"put": True, "post": None},
        "created_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        monitor_id = self.monitor_id

        id = self.id

        series_id = self.series_id

        metric_id = self.metric_id

        observation_id: Union[None, Unset, str]
        if isinstance(self.observation_id, Unset):
            observation_id = UNSET
        else:
            observation_id = self.observation_id

        value: Union[None, Unset, float]
        if isinstance(self.value, Unset):
            value = UNSET
        else:
            value = self.value

        fields: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.fields is None:
            fields = None
        elif not isinstance(self.fields, Unset):
            fields = self.fields.to_dict()

        tags: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.tags is None:
            tags = None
        elif not isinstance(self.tags, Unset):
            tags = self.tags.to_dict()

        creator_id = self.creator_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "monitor_id": monitor_id,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if series_id is not UNSET:
            field_dict["series_id"] = series_id
        if metric_id is not UNSET:
            field_dict["metric_id"] = metric_id
        if observation_id is not UNSET:
            field_dict["observation_id"] = observation_id
        if value is not UNSET:
            field_dict["value"] = value
        if fields is not UNSET:
            field_dict["fields"] = fields
        if tags is not UNSET:
            field_dict["tags"] = tags
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.any_object import AnyObject

        d = src_dict.copy()
        monitor_id = d.pop("monitor_id")

        id = d.pop("id", UNSET)

        series_id = d.pop("series_id", UNSET)

        metric_id = d.pop("metric_id", UNSET)

        def _parse_observation_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        observation_id = _parse_observation_id(d.pop("observation_id", UNSET))

        def _parse_value(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        value = _parse_value(d.pop("value", UNSET))

        _fields = d.pop("fields", UNSET)
        fields: Union[None, Unset, AnyObject]
        if isinstance(_fields, Unset):
            fields = UNSET
        elif _fields is None:
            fields = None
        else:
            fields = AnyObject.from_dict(_fields)

        _tags = d.pop("tags", UNSET)
        tags: Union[None, Unset, AnyObject]
        if isinstance(_tags, Unset):
            tags = UNSET
        elif _tags is None:
            tags = None
        else:
            tags = AnyObject.from_dict(_tags)

        creator_id = d.pop("creator_id", UNSET)

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        value = cls(
            monitor_id=monitor_id,
            id=id,
            series_id=series_id,
            metric_id=metric_id,
            observation_id=observation_id,
            value=value,
            fields=fields,
            tags=tags,
            creator_id=creator_id,
            created_at=created_at,
            deleted_at=deleted_at,
        )

        value.additional_properties = d
        return value

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.any_object import AnyObject

    ns["AnyObject"] = AnyObject
