from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="StatsSummary")


@_attrs_define
class StatsSummary:
    """
    Attributes:
        observations_total (Union[Unset, int]): Total number of observations.
        series_total (Union[Unset, int]): Total number of series.
        datasets_total (Union[Unset, int]): Total number of datasets.
        values_total (Union[Unset, int]): Total number of values.
    """

    observations_total: Union[Unset, int] = UNSET
    series_total: Union[Unset, int] = UNSET
    datasets_total: Union[Unset, int] = UNSET
    values_total: Union[Unset, int] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "observations_total": {"put": None, "post": None},
        "series_total": {"put": None, "post": None},
        "datasets_total": {"put": None, "post": None},
        "values_total": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        observations_total = self.observations_total

        series_total = self.series_total

        datasets_total = self.datasets_total

        values_total = self.values_total

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if observations_total is not UNSET:
            field_dict["observations_total"] = observations_total
        if series_total is not UNSET:
            field_dict["series_total"] = series_total
        if datasets_total is not UNSET:
            field_dict["datasets_total"] = datasets_total
        if values_total is not UNSET:
            field_dict["values_total"] = values_total

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        observations_total = d.pop("observations_total", UNSET)

        series_total = d.pop("series_total", UNSET)

        datasets_total = d.pop("datasets_total", UNSET)

        values_total = d.pop("values_total", UNSET)

        stats_summary = cls(
            observations_total=observations_total,
            series_total=series_total,
            datasets_total=datasets_total,
            values_total=values_total,
        )

        stats_summary.additional_properties = d
        return stats_summary

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
