from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.series import Series


T = TypeVar("T", bound="SeriesList")


@_attrs_define
class SeriesList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        series (List['Series']):
    """

    page: int
    total: int
    pages: int
    series: List["Series"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        series = []
        for series_item_data in self.series:
            series_item = series_item_data.to_dict()
            series.append(series_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "series": series,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.series import Series

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        series = []
        _series = d.pop("series")
        for series_item_data in _series:
            series_item = Series.from_dict(series_item_data)

            series.append(series_item)

        series_list = cls(
            page=page,
            total=total,
            pages=pages,
            series=series,
        )

        series_list.additional_properties = d
        return series_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.series import Series

    ns["Series"] = Series
