from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.propsim import Propsim


T = TypeVar("T", bound="PropsimList")


@_attrs_define
class PropsimList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        propsims (List['Propsim']):
    """

    page: int
    total: int
    pages: int
    propsims: List["Propsim"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        propsims = []
        for propsims_item_data in self.propsims:
            propsims_item = propsims_item_data.to_dict()
            propsims.append(propsims_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "propsims": propsims,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.propsim import Propsim

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        propsims = []
        _propsims = d.pop("propsims")
        for propsims_item_data in _propsims:
            propsims_item = Propsim.from_dict(propsims_item_data)

            propsims.append(propsims_item)

        propsim_list = cls(
            page=page,
            total=total,
            pages=pages,
            propsims=propsims,
        )

        propsim_list.additional_properties = d
        return propsim_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.propsim import Propsim

    ns["Propsim"] = Propsim
