import datetime
from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.propsim_status import PropsimStatus
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.propsim_job import PropsimJob


T = TypeVar("T", bound="Propsim")


@_attrs_define
class Propsim:
    """A Propsim represents a simulation run by a Propsim service.

    Attributes:
        name (str): The name of the propsim.
        radio_port_id (str): The radio port id associated with the propsim.
        id (Union[Unset, str]): The id of the propsim.
        description (Union[None, Unset, str]): A brief description of the propsim.
        radio_id (Union[Unset, str]): The radio id associated with the propsim, determined from radio_port_id by the
            server.
        element_id (Union[Unset, str]): The element id associated with the radio_port_id, set by the server.
        freq (Union[None, Unset, float]): The frequency, in MHz, at which the propsim is run.
        gain (Union[None, Unset, float]): The gain, in dB, at which the propsim is run.
        rx_height (Union[None, Unset, float]): The receiver height, in meters, at which the propsim is run.
        resolution (Union[None, Unset, float]): The resolution, in meters, at which the propsim is run.
        config (Union[Unset, Any]): The configuration blob passed to the propsim service.
        service_id (Union[Unset, str]): The id of the propsim service that is running this simulation.
        priority (Union[None, Unset, int]): The priority given to the propsim, if any.  0 is highest priority, and
            larger numbers descrease priority.  Only administrators may set priority; non-administrators will have priority
            set to a default priority.
        status (Union[Unset, PropsimStatus]): The status of a Propsim job or service.
        creator_id (Union[Unset, str]): The user id of the creator.
        updater_id (Union[None, Unset, str]): The user id of the updater.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        updated_at (Union[None, Unset, datetime.datetime]): Last modification time.
        finalized_at (Union[None, Unset, datetime.datetime]): Time at which propsim was finalized, if any.  Once the
            propsim is finalized, no new jobs may be added.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
        jobs (Union[Unset, List['PropsimJob']]): The list of propsim jobs in the propsim, when elaborate is enabled.
    """

    name: str
    radio_port_id: str
    id: Union[Unset, str] = UNSET
    description: Union[None, Unset, str] = UNSET
    radio_id: Union[Unset, str] = UNSET
    element_id: Union[Unset, str] = UNSET
    freq: Union[None, Unset, float] = UNSET
    gain: Union[None, Unset, float] = UNSET
    rx_height: Union[None, Unset, float] = UNSET
    resolution: Union[None, Unset, float] = UNSET
    config: Union[Unset, Any] = UNSET
    service_id: Union[Unset, str] = UNSET
    priority: Union[None, Unset, int] = UNSET
    status: Union[Unset, PropsimStatus] = UNSET
    creator_id: Union[Unset, str] = UNSET
    updater_id: Union[None, Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[None, Unset, datetime.datetime] = UNSET
    finalized_at: Union[None, Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    jobs: Union[Unset, List["PropsimJob"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "name": {"put": None, "post": None},
        "description": {"put": None, "post": None},
        "radio_port_id": {"put": True, "post": None},
        "radio_id": {"put": True, "post": True},
        "element_id": {"put": True, "post": None},
        "freq": {"put": None, "post": None},
        "gain": {"put": None, "post": None},
        "rx_height": {"put": None, "post": None},
        "resolution": {"put": None, "post": None},
        "config": {"put": None, "post": None},
        "service_id": {"put": True, "post": None},
        "priority": {"put": None, "post": None},
        "status": {"put": None, "post": None},
        "creator_id": {"put": True, "post": True},
        "updater_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "updated_at": {"put": True, "post": True},
        "finalized_at": {"put": None, "post": True},
        "deleted_at": {"put": True, "post": True},
        "jobs": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        name = self.name

        radio_port_id = self.radio_port_id

        id = self.id

        description: Union[None, Unset, str]
        if isinstance(self.description, Unset):
            description = UNSET
        else:
            description = self.description

        radio_id = self.radio_id

        element_id = self.element_id

        freq: Union[None, Unset, float]
        if isinstance(self.freq, Unset):
            freq = UNSET
        else:
            freq = self.freq

        gain: Union[None, Unset, float]
        if isinstance(self.gain, Unset):
            gain = UNSET
        else:
            gain = self.gain

        rx_height: Union[None, Unset, float]
        if isinstance(self.rx_height, Unset):
            rx_height = UNSET
        else:
            rx_height = self.rx_height

        resolution: Union[None, Unset, float]
        if isinstance(self.resolution, Unset):
            resolution = UNSET
        else:
            resolution = self.resolution

        config = self.config

        service_id = self.service_id

        priority: Union[None, Unset, int]
        if isinstance(self.priority, Unset):
            priority = UNSET
        else:
            priority = self.priority

        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        creator_id = self.creator_id

        updater_id: Union[None, Unset, str]
        if isinstance(self.updater_id, Unset):
            updater_id = UNSET
        else:
            updater_id = self.updater_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[None, Unset, str]
        if isinstance(self.updated_at, Unset):
            updated_at = UNSET
        elif isinstance(self.updated_at, datetime.datetime):
            updated_at = self.updated_at.isoformat()
        else:
            updated_at = self.updated_at

        finalized_at: Union[None, Unset, str]
        if isinstance(self.finalized_at, Unset):
            finalized_at = UNSET
        elif isinstance(self.finalized_at, datetime.datetime):
            finalized_at = self.finalized_at.isoformat()
        else:
            finalized_at = self.finalized_at

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        jobs: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.jobs, Unset):
            jobs = []
            for jobs_item_data in self.jobs:
                jobs_item = jobs_item_data.to_dict()
                jobs.append(jobs_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "radio_port_id": radio_port_id,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if description is not UNSET:
            field_dict["description"] = description
        if radio_id is not UNSET:
            field_dict["radio_id"] = radio_id
        if element_id is not UNSET:
            field_dict["element_id"] = element_id
        if freq is not UNSET:
            field_dict["freq"] = freq
        if gain is not UNSET:
            field_dict["gain"] = gain
        if rx_height is not UNSET:
            field_dict["rx_height"] = rx_height
        if resolution is not UNSET:
            field_dict["resolution"] = resolution
        if config is not UNSET:
            field_dict["config"] = config
        if service_id is not UNSET:
            field_dict["service_id"] = service_id
        if priority is not UNSET:
            field_dict["priority"] = priority
        if status is not UNSET:
            field_dict["status"] = status
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if updater_id is not UNSET:
            field_dict["updater_id"] = updater_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at
        if finalized_at is not UNSET:
            field_dict["finalized_at"] = finalized_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at
        if jobs is not UNSET:
            field_dict["jobs"] = jobs

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.propsim_job import PropsimJob

        d = src_dict.copy()
        name = d.pop("name")

        radio_port_id = d.pop("radio_port_id")

        id = d.pop("id", UNSET)

        def _parse_description(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        description = _parse_description(d.pop("description", UNSET))

        radio_id = d.pop("radio_id", UNSET)

        element_id = d.pop("element_id", UNSET)

        def _parse_freq(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        freq = _parse_freq(d.pop("freq", UNSET))

        def _parse_gain(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        gain = _parse_gain(d.pop("gain", UNSET))

        def _parse_rx_height(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        rx_height = _parse_rx_height(d.pop("rx_height", UNSET))

        def _parse_resolution(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        resolution = _parse_resolution(d.pop("resolution", UNSET))

        config = d.pop("config", UNSET)

        service_id = d.pop("service_id", UNSET)

        def _parse_priority(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        priority = _parse_priority(d.pop("priority", UNSET))

        _status = d.pop("status", UNSET)
        status: Union[Unset, PropsimStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = PropsimStatus(_status)

        creator_id = d.pop("creator_id", UNSET)

        def _parse_updater_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        updater_id = _parse_updater_id(d.pop("updater_id", UNSET))

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_updated_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                updated_at_type_0 = isoparse(data)

                return updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        updated_at = _parse_updated_at(d.pop("updated_at", UNSET))

        def _parse_finalized_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                finalized_at_type_0 = isoparse(data)

                return finalized_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        finalized_at = _parse_finalized_at(d.pop("finalized_at", UNSET))

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        jobs = []
        _jobs = d.pop("jobs", UNSET)
        for jobs_item_data in _jobs or []:
            jobs_item = PropsimJob.from_dict(jobs_item_data)

            jobs.append(jobs_item)

        propsim = cls(
            name=name,
            radio_port_id=radio_port_id,
            id=id,
            description=description,
            radio_id=radio_id,
            element_id=element_id,
            freq=freq,
            gain=gain,
            rx_height=rx_height,
            resolution=resolution,
            config=config,
            service_id=service_id,
            priority=priority,
            status=status,
            creator_id=creator_id,
            updater_id=updater_id,
            created_at=created_at,
            updated_at=updated_at,
            finalized_at=finalized_at,
            deleted_at=deleted_at,
            jobs=jobs,
        )

        propsim.additional_properties = d
        return propsim

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.propsim_job import PropsimJob

    ns["PropsimJob"] = PropsimJob
