from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.dataset_series import DatasetSeries


T = TypeVar("T", bound="DatasetSeriesList")


@_attrs_define
class DatasetSeriesList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        dataset_series (List['DatasetSeries']):
    """

    page: int
    total: int
    pages: int
    dataset_series: List["DatasetSeries"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        dataset_series = []
        for dataset_series_item_data in self.dataset_series:
            dataset_series_item = dataset_series_item_data.to_dict()
            dataset_series.append(dataset_series_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "dataset_series": dataset_series,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.dataset_series import DatasetSeries

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        dataset_series = []
        _dataset_series = d.pop("dataset_series")
        for dataset_series_item_data in _dataset_series:
            dataset_series_item = DatasetSeries.from_dict(dataset_series_item_data)

            dataset_series.append(dataset_series_item)

        dataset_series_list = cls(
            page=page,
            total=total,
            pages=pages,
            dataset_series=dataset_series,
        )

        dataset_series_list.additional_properties = d
        return dataset_series_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.dataset_series import DatasetSeries

    ns["DatasetSeries"] = DatasetSeries
