from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.dataset import Dataset


T = TypeVar("T", bound="DatasetList")


@_attrs_define
class DatasetList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        datasets (List['Dataset']):
    """

    page: int
    total: int
    pages: int
    datasets: List["Dataset"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        datasets = []
        for datasets_item_data in self.datasets:
            datasets_item = datasets_item_data.to_dict()
            datasets.append(datasets_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "datasets": datasets,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.dataset import Dataset

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        datasets = []
        _datasets = d.pop("datasets")
        for datasets_item_data in _datasets:
            datasets_item = Dataset.from_dict(datasets_item_data)

            datasets.append(datasets_item)

        dataset_list = cls(
            page=page,
            total=total,
            pages=pages,
            datasets=datasets,
        )

        dataset_list.additional_properties = d
        return dataset_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.dataset import Dataset

    ns["Dataset"] = Dataset
