import functools
from typing import (
    Any,
    Callable,
    Concatenate,
    ParamSpec,
    TypeAlias,
    TypeVar,
    cast,
)

from .api.dataset.create_dataset import (
    asyncio_detailed as create_dataset_asyncio_detailed,
)
from .api.dataset.create_dataset_series import (
    asyncio_detailed as create_dataset_series_asyncio_detailed,
)
from .api.dataset.delete_dataset import (
    asyncio_detailed as delete_dataset_asyncio_detailed,
)
from .api.dataset.delete_dataset_series import (
    asyncio_detailed as delete_dataset_series_asyncio_detailed,
)
from .api.dataset.get_dataset import asyncio_detailed as get_dataset_asyncio_detailed
from .api.dataset.list_datasets import (
    asyncio_detailed as list_datasets_asyncio_detailed,
)
from .api.dataset.update_dataset import (
    asyncio_detailed as update_dataset_asyncio_detailed,
)
from .api.metric.create_metric import asyncio_detailed as create_metric_asyncio_detailed
from .api.metric.delete_metric import asyncio_detailed as delete_metric_asyncio_detailed
from .api.metric.get_metric import asyncio_detailed as get_metric_asyncio_detailed
from .api.metric.list_metrics import asyncio_detailed as list_metrics_asyncio_detailed
from .api.metric.update_metric import asyncio_detailed as update_metric_asyncio_detailed
from .api.observation.create_observation import (
    asyncio_detailed as create_observation_asyncio_detailed,
)
from .api.observation.delete_observation import (
    asyncio_detailed as delete_observation_asyncio_detailed,
)
from .api.observation.get_observation import (
    asyncio_detailed as get_observation_asyncio_detailed,
)
from .api.observation.get_observation_raw import (
    asyncio_detailed as get_observation_raw_asyncio_detailed,
)
from .api.observation.list_observations import (
    asyncio_detailed as list_observations_asyncio_detailed,
)
from .api.observation.update_observation import (
    asyncio_detailed as update_observation_asyncio_detailed,
)
from .api.propsim.delete_propsim import (
    asyncio_detailed as delete_propsim_asyncio_detailed,
)
from .api.propsim.get_propsim import asyncio_detailed as get_propsim_asyncio_detailed
from .api.propsim.get_propsim_job import (
    asyncio_detailed as get_propsim_job_asyncio_detailed,
)
from .api.propsim.get_propsim_job_output import (
    asyncio_detailed as get_propsim_job_output_asyncio_detailed,
)
from .api.propsim.list_propsim_job_outputs import (
    asyncio_detailed as list_propsim_job_outputs_asyncio_detailed,
)
from .api.propsim.list_propsim_jobs import (
    asyncio_detailed as list_propsim_jobs_asyncio_detailed,
)
from .api.propsim.list_propsims import (
    asyncio_detailed as list_propsims_asyncio_detailed,
)
from .api.series.create_series import asyncio_detailed as create_series_asyncio_detailed
from .api.series.create_series_geolocation import (
    asyncio_detailed as create_series_geolocation_asyncio_detailed,
)
from .api.series.create_series_grant import (
    asyncio_detailed as create_series_grant_asyncio_detailed,
)
from .api.series.delete_series import asyncio_detailed as delete_series_asyncio_detailed
from .api.series.delete_series_geolocation import (
    asyncio_detailed as delete_series_geolocation_asyncio_detailed,
)
from .api.series.delete_series_grant import (
    asyncio_detailed as delete_series_grant_asyncio_detailed,
)
from .api.series.get_series import asyncio_detailed as get_series_asyncio_detailed
from .api.series.list_series import asyncio_detailed as list_series_asyncio_detailed
from .api.series.list_series_values_influx import (
    asyncio_detailed as list_series_values_influx_asyncio_detailed,
)
from .api.series.list_series_values_internal import (
    asyncio_detailed as list_series_values_internal_asyncio_detailed,
)
from .api.series.update_series import asyncio_detailed as update_series_asyncio_detailed
from .api.stats.get_stats_summary import (
    asyncio_detailed as get_stats_summary_asyncio_detailed,
)
from .api.store.create_store import asyncio_detailed as create_store_asyncio_detailed
from .api.store.delete_store import asyncio_detailed as delete_store_asyncio_detailed
from .api.store.get_store import asyncio_detailed as get_store_asyncio_detailed
from .api.store.list_stores import asyncio_detailed as list_stores_asyncio_detailed
from .api.store.update_store import asyncio_detailed as update_store_asyncio_detailed
from .api.subscription.create_subscription import (
    asyncio_detailed as create_subscription_asyncio_detailed,
)
from .api.subscription.delete_subscription import (
    asyncio_detailed as delete_subscription_asyncio_detailed,
)
from .api.subscription.get_subscription_events import (
    asyncio_detailed as get_subscription_events_asyncio_detailed,
)
from .api.subscription.get_subscriptions import (
    asyncio_detailed as get_subscriptions_asyncio_detailed,
)
from .api.value.create_value import asyncio_detailed as create_value_asyncio_detailed
from .api.version.get_version import asyncio_detailed as get_version_asyncio_detailed

T = TypeVar("T", bound=Callable[..., Any])
P = ParamSpec("P")
R = TypeVar("R")
MethodT: TypeAlias = Callable[Concatenate[Any, P], R]


def wraps_method(
    wrapped: MethodT[P, R],
    wrapper_name: str,
    **kwargs,
) -> Callable[[MethodT[P, R]], MethodT[P, R]]:
    def decorator(f: MethodT[P, R]) -> MethodT[P, R]:
        @functools.wraps(wrapped, **kwargs)
        def wrapper(self: Any, *args: P.args, **kwargs: P.kwargs) -> R:
            return f(self, *args, **kwargs)

        if wrapper_name:
            wrapper.__name__ = wrapper_name
        return cast(MethodT[P, R], wrapper)

    return decorator


class ClientApiAsyncioMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(self, *args, **kwargs, client=self)

    @wraps_method(get_version_asyncio_detailed, "get_version")  # type: ignore
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_stats_summary_asyncio_detailed, "get_stats_summary")  # type: ignore
    def get_stats_summary(self, *args, **kwargs):
        return self._call_api_func(get_stats_summary_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_observations_asyncio_detailed, "list_observations")  # type: ignore
    def list_observations(self, *args, **kwargs):
        return self._call_api_func(list_observations_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_observation_asyncio_detailed, "create_observation")  # type: ignore
    def create_observation(self, *args, **kwargs):
        return self._call_api_func(create_observation_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_observation_asyncio_detailed, "get_observation")  # type: ignore
    def get_observation(self, *args, **kwargs):
        return self._call_api_func(get_observation_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_observation_asyncio_detailed, "update_observation")  # type: ignore
    def update_observation(self, *args, **kwargs):
        return self._call_api_func(update_observation_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_observation_asyncio_detailed, "delete_observation")  # type: ignore
    def delete_observation(self, *args, **kwargs):
        return self._call_api_func(delete_observation_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_observation_raw_asyncio_detailed, "get_observation_raw")  # type: ignore
    def get_observation_raw(self, *args, **kwargs):
        return self._call_api_func(
            get_observation_raw_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_metrics_asyncio_detailed, "list_metrics")  # type: ignore
    def list_metrics(self, *args, **kwargs):
        return self._call_api_func(list_metrics_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_metric_asyncio_detailed, "create_metric")  # type: ignore
    def create_metric(self, *args, **kwargs):
        return self._call_api_func(create_metric_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_metric_asyncio_detailed, "get_metric")  # type: ignore
    def get_metric(self, *args, **kwargs):
        return self._call_api_func(get_metric_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_metric_asyncio_detailed, "update_metric")  # type: ignore
    def update_metric(self, *args, **kwargs):
        return self._call_api_func(update_metric_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_metric_asyncio_detailed, "delete_metric")  # type: ignore
    def delete_metric(self, *args, **kwargs):
        return self._call_api_func(delete_metric_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_value_asyncio_detailed, "create_value")  # type: ignore
    def create_value(self, *args, **kwargs):
        return self._call_api_func(create_value_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_series_asyncio_detailed, "list_series")  # type: ignore
    def list_series(self, *args, **kwargs):
        return self._call_api_func(list_series_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_series_asyncio_detailed, "create_series")  # type: ignore
    def create_series(self, *args, **kwargs):
        return self._call_api_func(create_series_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_series_asyncio_detailed, "get_series")  # type: ignore
    def get_series(self, *args, **kwargs):
        return self._call_api_func(get_series_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_series_asyncio_detailed, "update_series")  # type: ignore
    def update_series(self, *args, **kwargs):
        return self._call_api_func(update_series_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_series_asyncio_detailed, "delete_series")  # type: ignore
    def delete_series(self, *args, **kwargs):
        return self._call_api_func(delete_series_asyncio_detailed, *args, **kwargs)

    @wraps_method(
        list_series_values_internal_asyncio_detailed, "list_series_values_internal"
    )  # type: ignore
    def list_series_values_internal(self, *args, **kwargs):
        return self._call_api_func(
            list_series_values_internal_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        list_series_values_influx_asyncio_detailed, "list_series_values_influx"
    )  # type: ignore
    def list_series_values_influx(self, *args, **kwargs):
        return self._call_api_func(
            list_series_values_influx_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        create_series_geolocation_asyncio_detailed, "create_series_geolocation"
    )  # type: ignore
    def create_series_geolocation(self, *args, **kwargs):
        return self._call_api_func(
            create_series_geolocation_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(
        delete_series_geolocation_asyncio_detailed, "delete_series_geolocation"
    )  # type: ignore
    def delete_series_geolocation(self, *args, **kwargs):
        return self._call_api_func(
            delete_series_geolocation_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(create_series_grant_asyncio_detailed, "create_series_grant")  # type: ignore
    def create_series_grant(self, *args, **kwargs):
        return self._call_api_func(
            create_series_grant_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_series_grant_asyncio_detailed, "delete_series_grant")  # type: ignore
    def delete_series_grant(self, *args, **kwargs):
        return self._call_api_func(
            delete_series_grant_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_datasets_asyncio_detailed, "list_datasets")  # type: ignore
    def list_datasets(self, *args, **kwargs):
        return self._call_api_func(list_datasets_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_dataset_asyncio_detailed, "create_dataset")  # type: ignore
    def create_dataset(self, *args, **kwargs):
        return self._call_api_func(create_dataset_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_dataset_asyncio_detailed, "get_dataset")  # type: ignore
    def get_dataset(self, *args, **kwargs):
        return self._call_api_func(get_dataset_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_dataset_asyncio_detailed, "update_dataset")  # type: ignore
    def update_dataset(self, *args, **kwargs):
        return self._call_api_func(update_dataset_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_dataset_asyncio_detailed, "delete_dataset")  # type: ignore
    def delete_dataset(self, *args, **kwargs):
        return self._call_api_func(delete_dataset_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_dataset_series_asyncio_detailed, "create_dataset_series")  # type: ignore
    def create_dataset_series(self, *args, **kwargs):
        return self._call_api_func(
            create_dataset_series_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_dataset_series_asyncio_detailed, "delete_dataset_series")  # type: ignore
    def delete_dataset_series(self, *args, **kwargs):
        return self._call_api_func(
            delete_dataset_series_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(list_stores_asyncio_detailed, "list_stores")  # type: ignore
    def list_stores(self, *args, **kwargs):
        return self._call_api_func(list_stores_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_store_asyncio_detailed, "create_store")  # type: ignore
    def create_store(self, *args, **kwargs):
        return self._call_api_func(create_store_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_store_asyncio_detailed, "get_store")  # type: ignore
    def get_store(self, *args, **kwargs):
        return self._call_api_func(get_store_asyncio_detailed, *args, **kwargs)

    @wraps_method(update_store_asyncio_detailed, "update_store")  # type: ignore
    def update_store(self, *args, **kwargs):
        return self._call_api_func(update_store_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_store_asyncio_detailed, "delete_store")  # type: ignore
    def delete_store(self, *args, **kwargs):
        return self._call_api_func(delete_store_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_propsims_asyncio_detailed, "list_propsims")  # type: ignore
    def list_propsims(self, *args, **kwargs):
        return self._call_api_func(list_propsims_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_propsim_asyncio_detailed, "get_propsim")  # type: ignore
    def get_propsim(self, *args, **kwargs):
        return self._call_api_func(get_propsim_asyncio_detailed, *args, **kwargs)

    @wraps_method(delete_propsim_asyncio_detailed, "delete_propsim")  # type: ignore
    def delete_propsim(self, *args, **kwargs):
        return self._call_api_func(delete_propsim_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_propsim_jobs_asyncio_detailed, "list_propsim_jobs")  # type: ignore
    def list_propsim_jobs(self, *args, **kwargs):
        return self._call_api_func(list_propsim_jobs_asyncio_detailed, *args, **kwargs)

    @wraps_method(get_propsim_job_asyncio_detailed, "get_propsim_job")  # type: ignore
    def get_propsim_job(self, *args, **kwargs):
        return self._call_api_func(get_propsim_job_asyncio_detailed, *args, **kwargs)

    @wraps_method(list_propsim_job_outputs_asyncio_detailed, "list_propsim_job_outputs")  # type: ignore
    def list_propsim_job_outputs(self, *args, **kwargs):
        return self._call_api_func(
            list_propsim_job_outputs_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_propsim_job_output_asyncio_detailed, "get_propsim_job_output")  # type: ignore
    def get_propsim_job_output(self, *args, **kwargs):
        return self._call_api_func(
            get_propsim_job_output_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_subscriptions_asyncio_detailed, "get_subscriptions")  # type: ignore
    def get_subscriptions(self, *args, **kwargs):
        return self._call_api_func(get_subscriptions_asyncio_detailed, *args, **kwargs)

    @wraps_method(create_subscription_asyncio_detailed, "create_subscription")  # type: ignore
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(
            create_subscription_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(delete_subscription_asyncio_detailed, "delete_subscription")  # type: ignore
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(
            delete_subscription_asyncio_detailed, *args, **kwargs
        )

    @wraps_method(get_subscription_events_asyncio_detailed, "get_subscription_events")  # type: ignore
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_asyncio_detailed, *args, **kwargs
        )
