from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_propsim_job_outputs_sort import ListPropsimJobOutputsSort
from ...models.propsim_job_output_list import PropsimJobOutputList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    propsim_id: str,
    propsim_job_id: str,
    *,
    sort: Union[Unset, ListPropsimJobOutputsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/propsims/{propsim_id}/jobs/{propsim_job_id}/outputs".format(
            propsim_id=propsim_id,
            propsim_job_id=propsim_job_id,
        ),
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, PropsimJobOutputList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = PropsimJobOutputList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.NOT_FOUND:
        try:
            response_404 = Error.from_dict(response.json())

            return response_404
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, PropsimJobOutputList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    client: AuthenticatedClient,
    propsim_id: str,
    propsim_job_id: str,
    *,
    sort: Union[Unset, ListPropsimJobOutputsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, PropsimJobOutputList]]:
    """Retrieve a list of outputs for a specific job for a specific propsim.

    Args:
        propsim_id (str): The target propsim.
        propsim_job_id (str): The target propsim job.
        sort (Union[Unset, ListPropsimJobOutputsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, PropsimJobOutputList]]
    """

    kwargs = _get_kwargs(
        propsim_id=propsim_id,
        propsim_job_id=propsim_job_id,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    client: AuthenticatedClient,
    propsim_id: str,
    propsim_job_id: str,
    *,
    sort: Union[Unset, ListPropsimJobOutputsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, PropsimJobOutputList]]:
    """Retrieve a list of outputs for a specific job for a specific propsim.

    Args:
        propsim_id (str): The target propsim.
        propsim_job_id (str): The target propsim job.
        sort (Union[Unset, ListPropsimJobOutputsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, PropsimJobOutputList]
    """

    return sync_detailed(
        propsim_id=propsim_id,
        propsim_job_id=propsim_job_id,
        client=client,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    client: AuthenticatedClient,
    propsim_id: str,
    propsim_job_id: str,
    *,
    sort: Union[Unset, ListPropsimJobOutputsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, PropsimJobOutputList]]:
    """Retrieve a list of outputs for a specific job for a specific propsim.

    Args:
        propsim_id (str): The target propsim.
        propsim_job_id (str): The target propsim job.
        sort (Union[Unset, ListPropsimJobOutputsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, PropsimJobOutputList]]
    """

    kwargs = _get_kwargs(
        propsim_id=propsim_id,
        propsim_job_id=propsim_job_id,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    client: AuthenticatedClient,
    propsim_id: str,
    propsim_job_id: str,
    *,
    sort: Union[Unset, ListPropsimJobOutputsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, PropsimJobOutputList]]:
    """Retrieve a list of outputs for a specific job for a specific propsim.

    Args:
        propsim_id (str): The target propsim.
        propsim_job_id (str): The target propsim job.
        sort (Union[Unset, ListPropsimJobOutputsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, PropsimJobOutputList]
    """

    return (
        await asyncio_detailed(
            propsim_id=propsim_id,
            propsim_job_id=propsim_job_id,
            client=client,
            sort=sort,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
