import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_observations_end_field import ListObservationsEndField
from ...models.list_observations_kind import ListObservationsKind
from ...models.list_observations_sort import ListObservationsSort
from ...models.list_observations_start_field import ListObservationsStartField
from ...models.observation_list import ObservationList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    element_id: Union[Unset, str] = UNSET,
    monitor_id: Union[Unset, str] = UNSET,
    observation: Union[Unset, str] = UNSET,
    types: Union[Unset, str] = UNSET,
    format_: Union[Unset, str] = UNSET,
    freq: Union[Unset, int] = UNSET,
    violation: Union[Unset, bool] = False,
    intereference: Union[Unset, bool] = False,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListObservationsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListObservationsKind] = UNSET,
    end_field: Union[Unset, ListObservationsEndField] = UNSET,
    sort: Union[Unset, ListObservationsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    data_inline: Union[Unset, bool] = UNSET,
    metadata_inline: Union[Unset, bool] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["element_id"] = element_id

    params["monitor_id"] = monitor_id

    params["observation"] = observation

    params["types"] = types

    params["format"] = format_

    params["freq"] = freq

    params["violation"] = violation

    params["intereference"] = intereference

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["data_inline"] = data_inline

    params["metadata_inline"] = metadata_inline

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/observations",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, ObservationList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = ObservationList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, ObservationList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    monitor_id: Union[Unset, str] = UNSET,
    observation: Union[Unset, str] = UNSET,
    types: Union[Unset, str] = UNSET,
    format_: Union[Unset, str] = UNSET,
    freq: Union[Unset, int] = UNSET,
    violation: Union[Unset, bool] = False,
    intereference: Union[Unset, bool] = False,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListObservationsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListObservationsKind] = UNSET,
    end_field: Union[Unset, ListObservationsEndField] = UNSET,
    sort: Union[Unset, ListObservationsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    data_inline: Union[Unset, bool] = UNSET,
    metadata_inline: Union[Unset, bool] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, ObservationList]]:
    """Retrieve a list of observations.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        monitor_id (Union[Unset, str]): Filters by monitor that produced the observation.
        observation (Union[Unset, str]): Filters by observation description.
        types (Union[Unset, str]): Search by observation type.
        format_ (Union[Unset, str]): Search by observation format.
        freq (Union[Unset, int]): Search by observation frequency.
        violation (Union[Unset, bool]): If true, show only violation observations. Default: False.
        intereference (Union[Unset, bool]): If true, show only interference observations. Default:
            False.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListObservationsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListObservationsKind]):
        end_field (Union[Unset, ListObservationsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListObservationsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        data_inline (Union[Unset, bool]): We do not return data inline unless explicitly
            requested.
        metadata_inline (Union[Unset, bool]): We do not return metadata inline unless explicitly
            requested.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, ObservationList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        monitor_id=monitor_id,
        observation=observation,
        types=types,
        format_=format_,
        freq=freq,
        violation=violation,
        intereference=intereference,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        data_inline=data_inline,
        metadata_inline=metadata_inline,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    monitor_id: Union[Unset, str] = UNSET,
    observation: Union[Unset, str] = UNSET,
    types: Union[Unset, str] = UNSET,
    format_: Union[Unset, str] = UNSET,
    freq: Union[Unset, int] = UNSET,
    violation: Union[Unset, bool] = False,
    intereference: Union[Unset, bool] = False,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListObservationsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListObservationsKind] = UNSET,
    end_field: Union[Unset, ListObservationsEndField] = UNSET,
    sort: Union[Unset, ListObservationsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    data_inline: Union[Unset, bool] = UNSET,
    metadata_inline: Union[Unset, bool] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, ObservationList]]:
    """Retrieve a list of observations.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        monitor_id (Union[Unset, str]): Filters by monitor that produced the observation.
        observation (Union[Unset, str]): Filters by observation description.
        types (Union[Unset, str]): Search by observation type.
        format_ (Union[Unset, str]): Search by observation format.
        freq (Union[Unset, int]): Search by observation frequency.
        violation (Union[Unset, bool]): If true, show only violation observations. Default: False.
        intereference (Union[Unset, bool]): If true, show only interference observations. Default:
            False.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListObservationsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListObservationsKind]):
        end_field (Union[Unset, ListObservationsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListObservationsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        data_inline (Union[Unset, bool]): We do not return data inline unless explicitly
            requested.
        metadata_inline (Union[Unset, bool]): We do not return metadata inline unless explicitly
            requested.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, ObservationList]
    """

    return sync_detailed(
        client=client,
        element_id=element_id,
        monitor_id=monitor_id,
        observation=observation,
        types=types,
        format_=format_,
        freq=freq,
        violation=violation,
        intereference=intereference,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        data_inline=data_inline,
        metadata_inline=metadata_inline,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    monitor_id: Union[Unset, str] = UNSET,
    observation: Union[Unset, str] = UNSET,
    types: Union[Unset, str] = UNSET,
    format_: Union[Unset, str] = UNSET,
    freq: Union[Unset, int] = UNSET,
    violation: Union[Unset, bool] = False,
    intereference: Union[Unset, bool] = False,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListObservationsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListObservationsKind] = UNSET,
    end_field: Union[Unset, ListObservationsEndField] = UNSET,
    sort: Union[Unset, ListObservationsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    data_inline: Union[Unset, bool] = UNSET,
    metadata_inline: Union[Unset, bool] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, ObservationList]]:
    """Retrieve a list of observations.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        monitor_id (Union[Unset, str]): Filters by monitor that produced the observation.
        observation (Union[Unset, str]): Filters by observation description.
        types (Union[Unset, str]): Search by observation type.
        format_ (Union[Unset, str]): Search by observation format.
        freq (Union[Unset, int]): Search by observation frequency.
        violation (Union[Unset, bool]): If true, show only violation observations. Default: False.
        intereference (Union[Unset, bool]): If true, show only interference observations. Default:
            False.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListObservationsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListObservationsKind]):
        end_field (Union[Unset, ListObservationsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListObservationsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        data_inline (Union[Unset, bool]): We do not return data inline unless explicitly
            requested.
        metadata_inline (Union[Unset, bool]): We do not return metadata inline unless explicitly
            requested.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, ObservationList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        monitor_id=monitor_id,
        observation=observation,
        types=types,
        format_=format_,
        freq=freq,
        violation=violation,
        intereference=intereference,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        data_inline=data_inline,
        metadata_inline=metadata_inline,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    monitor_id: Union[Unset, str] = UNSET,
    observation: Union[Unset, str] = UNSET,
    types: Union[Unset, str] = UNSET,
    format_: Union[Unset, str] = UNSET,
    freq: Union[Unset, int] = UNSET,
    violation: Union[Unset, bool] = False,
    intereference: Union[Unset, bool] = False,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListObservationsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListObservationsKind] = UNSET,
    end_field: Union[Unset, ListObservationsEndField] = UNSET,
    sort: Union[Unset, ListObservationsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    data_inline: Union[Unset, bool] = UNSET,
    metadata_inline: Union[Unset, bool] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, ObservationList]]:
    """Retrieve a list of observations.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        monitor_id (Union[Unset, str]): Filters by monitor that produced the observation.
        observation (Union[Unset, str]): Filters by observation description.
        types (Union[Unset, str]): Search by observation type.
        format_ (Union[Unset, str]): Search by observation format.
        freq (Union[Unset, int]): Search by observation frequency.
        violation (Union[Unset, bool]): If true, show only violation observations. Default: False.
        intereference (Union[Unset, bool]): If true, show only interference observations. Default:
            False.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListObservationsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListObservationsKind]):
        end_field (Union[Unset, ListObservationsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListObservationsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        data_inline (Union[Unset, bool]): We do not return data inline unless explicitly
            requested.
        metadata_inline (Union[Unset, bool]): We do not return metadata inline unless explicitly
            requested.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, ObservationList]
    """

    return (
        await asyncio_detailed(
            client=client,
            element_id=element_id,
            monitor_id=monitor_id,
            observation=observation,
            types=types,
            format_=format_,
            freq=freq,
            violation=violation,
            intereference=intereference,
            start=start,
            start_field=start_field,
            end=end,
            kind=kind,
            end_field=end_field,
            sort=sort,
            sort_asc=sort_asc,
            data_inline=data_inline,
            metadata_inline=metadata_inline,
            page=page,
            items_per_page=items_per_page,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
