import datetime
from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="Version")


@_attrs_define
class Version:
    """
    Attributes:
        major (int):
        minor (int):  Example: 1.
        patch (int):
        version (str):  Example: 0.1.0.
        branch (Union[Unset, str]):  Example: master.
        build_timestamp (Union[Unset, datetime.datetime]):  Example: 2020-12-18T21:06:28.000Z.
        commit (Union[Unset, str]):  Example: deadbeef.
    """

    major: int
    minor: int
    patch: int
    version: str
    branch: Union[Unset, str] = UNSET
    build_timestamp: Union[Unset, datetime.datetime] = UNSET
    commit: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "branch": {"put": None, "post": None},
        "build_timestamp": {"put": None, "post": None},
        "commit": {"put": None, "post": None},
        "major": {"put": None, "post": None},
        "minor": {"put": None, "post": None},
        "patch": {"put": None, "post": None},
        "version": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        major = self.major

        minor = self.minor

        patch = self.patch

        version = self.version

        branch = self.branch

        build_timestamp: Union[Unset, str] = UNSET
        if not isinstance(self.build_timestamp, Unset):
            build_timestamp = self.build_timestamp.isoformat()

        commit = self.commit

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "major": major,
                "minor": minor,
                "patch": patch,
                "version": version,
            }
        )
        if branch is not UNSET:
            field_dict["branch"] = branch
        if build_timestamp is not UNSET:
            field_dict["build_timestamp"] = build_timestamp
        if commit is not UNSET:
            field_dict["commit"] = commit

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        major = d.pop("major")

        minor = d.pop("minor")

        patch = d.pop("patch")

        version = d.pop("version")

        branch = d.pop("branch", UNSET)

        _build_timestamp = d.pop("build_timestamp", UNSET)
        build_timestamp: Union[Unset, datetime.datetime]
        if isinstance(_build_timestamp, Unset):
            build_timestamp = UNSET
        else:
            build_timestamp = isoparse(_build_timestamp)

        commit = d.pop("commit", UNSET)

        version = cls(
            major=major,
            minor=minor,
            patch=patch,
            version=version,
            branch=branch,
            build_timestamp=build_timestamp,
            commit=commit,
        )

        version.additional_properties = d
        return version

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
