from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.grant_change import GrantChange


T = TypeVar("T", bound="GrantChangeList")


@_attrs_define
class GrantChangeList:
    """
    Attributes:
        page (int): The current page of results.
        total (int): The total number of records available.
        pages (int): The total number of pages available.
        grant_changes (List['GrantChange']):
    """

    page: int
    total: int
    pages: int
    grant_changes: List["GrantChange"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        grant_changes = []
        for grant_changes_item_data in self.grant_changes:
            grant_changes_item = grant_changes_item_data.to_dict()
            grant_changes.append(grant_changes_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "page": page,
                "total": total,
                "pages": pages,
                "grant_changes": grant_changes,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.grant_change import GrantChange

        d = src_dict.copy()
        page = d.pop("page")

        total = d.pop("total")

        pages = d.pop("pages")

        grant_changes = []
        _grant_changes = d.pop("grant_changes")
        for grant_changes_item_data in _grant_changes:
            grant_changes_item = GrantChange.from_dict(grant_changes_item_data)

            grant_changes.append(grant_changes_item)

        grant_change_list = cls(
            page=page,
            total=total,
            pages=pages,
            grant_changes=grant_changes,
        )

        grant_change_list.additional_properties = d
        return grant_change_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.grant_change import GrantChange

    ns["GrantChange"] = GrantChange
