import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="GrantAlarmLog")


@_attrs_define
class GrantAlarmLog:
    """Describes a log entry associated with a grant alarm.

    Attributes:
        grant_alarm_id (str): The id of the associated grant alarm.
        alarming (bool): Whether the grant alarm is alarming at the time of the log entry.
        current_value (float): The current value of the grant alarm at the time of the log entry.
        id (Union[Unset, str]): The id of the grant alarm log entry.
        message (Union[None, Unset, str]): The log message.
        created_at (Union[Unset, datetime.datetime]): Creation time.
    """

    grant_alarm_id: str
    alarming: bool
    current_value: float
    id: Union[Unset, str] = UNSET
    message: Union[None, Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "grant_alarm_id": {"put": True, "post": True},
        "alarming": {"put": True, "post": True},
        "current_value": {"put": True, "post": True},
        "message": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        grant_alarm_id = self.grant_alarm_id

        alarming = self.alarming

        current_value = self.current_value

        id = self.id

        message: Union[None, Unset, str]
        if isinstance(self.message, Unset):
            message = UNSET
        else:
            message = self.message

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "grant_alarm_id": grant_alarm_id,
                "alarming": alarming,
                "current_value": current_value,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if message is not UNSET:
            field_dict["message"] = message
        if created_at is not UNSET:
            field_dict["created_at"] = created_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        grant_alarm_id = d.pop("grant_alarm_id")

        alarming = d.pop("alarming")

        current_value = d.pop("current_value")

        id = d.pop("id", UNSET)

        def _parse_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        message = _parse_message(d.pop("message", UNSET))

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        grant_alarm_log = cls(
            grant_alarm_id=grant_alarm_id,
            alarming=alarming,
            current_value=current_value,
            id=id,
            message=message,
            created_at=created_at,
        )

        grant_alarm_log.additional_properties = d
        return grant_alarm_log

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
