import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="GrantAlarm")


@_attrs_define
class GrantAlarm:
    """Describes an alarm associated with a grant.

    Attributes:
        grant_id (str): The id of the associated grant.
        element_id (str): The id of the associated element.
        spectrum_id (Union[None, str]): The id of the associated spectrum.
        name (str): The name of the grant alarm.
        metric (str): The metric associated with the grant alarm.
        comparator (str): The comparator associated with the grant alarm.
        threshold (float): The threshold associated with the grant alarm.
        id (Union[Unset, str]): The id of the grant alarm.
        rt_int_constraint_id (Union[None, Unset, str]): The id of the associated runtime interference constraint, if
            any.
        aggregator (Union[None, Unset, str]): The aggregator function associated with the grant alarm.
        period (Union[None, Unset, int]): The period (in seconds) associated with the grant alarm.
        value (Union[Unset, float]): The value associated with the grant alarm.
        alarming (Union[None, Unset, bool]): Whether the grant alarm is currently alarming.
        current_value (Union[Unset, float]): The current value associated with the grant alarm.
        creator_id (Union[Unset, str]): The user id of the creator.
        updater_id (Union[None, Unset, str]): The user id of the updater.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        updated_at (Union[None, Unset, datetime.datetime]): Last modification time.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
    """

    grant_id: str
    element_id: str
    spectrum_id: Union[None, str]
    name: str
    metric: str
    comparator: str
    threshold: float
    id: Union[Unset, str] = UNSET
    rt_int_constraint_id: Union[None, Unset, str] = UNSET
    aggregator: Union[None, Unset, str] = UNSET
    period: Union[None, Unset, int] = UNSET
    value: Union[Unset, float] = UNSET
    alarming: Union[None, Unset, bool] = UNSET
    current_value: Union[Unset, float] = UNSET
    creator_id: Union[Unset, str] = UNSET
    updater_id: Union[None, Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    updated_at: Union[None, Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "grant_id": {"put": True, "post": None},
        "element_id": {"put": True, "post": None},
        "spectrum_id": {"put": True, "post": None},
        "rt_int_constraint_id": {"put": True, "post": None},
        "name": {"put": True, "post": None},
        "metric": {"put": True, "post": None},
        "comparator": {"put": True, "post": None},
        "threshold": {"put": True, "post": None},
        "aggregator": {"put": True, "post": None},
        "period": {"put": True, "post": None},
        "value": {"put": True, "post": None},
        "alarming": {"put": True, "post": True},
        "current_value": {"put": True, "post": True},
        "creator_id": {"put": True, "post": True},
        "updater_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "updated_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        grant_id = self.grant_id

        element_id = self.element_id

        spectrum_id: Union[None, str]
        spectrum_id = self.spectrum_id

        name = self.name

        metric = self.metric

        comparator = self.comparator

        threshold = self.threshold

        id = self.id

        rt_int_constraint_id: Union[None, Unset, str]
        if isinstance(self.rt_int_constraint_id, Unset):
            rt_int_constraint_id = UNSET
        else:
            rt_int_constraint_id = self.rt_int_constraint_id

        aggregator: Union[None, Unset, str]
        if isinstance(self.aggregator, Unset):
            aggregator = UNSET
        else:
            aggregator = self.aggregator

        period: Union[None, Unset, int]
        if isinstance(self.period, Unset):
            period = UNSET
        else:
            period = self.period

        value = self.value

        alarming: Union[None, Unset, bool]
        if isinstance(self.alarming, Unset):
            alarming = UNSET
        else:
            alarming = self.alarming

        current_value = self.current_value

        creator_id = self.creator_id

        updater_id: Union[None, Unset, str]
        if isinstance(self.updater_id, Unset):
            updater_id = UNSET
        else:
            updater_id = self.updater_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        updated_at: Union[None, Unset, str]
        if isinstance(self.updated_at, Unset):
            updated_at = UNSET
        elif isinstance(self.updated_at, datetime.datetime):
            updated_at = self.updated_at.isoformat()
        else:
            updated_at = self.updated_at

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "grant_id": grant_id,
                "element_id": element_id,
                "spectrum_id": spectrum_id,
                "name": name,
                "metric": metric,
                "comparator": comparator,
                "threshold": threshold,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if rt_int_constraint_id is not UNSET:
            field_dict["rt_int_constraint_id"] = rt_int_constraint_id
        if aggregator is not UNSET:
            field_dict["aggregator"] = aggregator
        if period is not UNSET:
            field_dict["period"] = period
        if value is not UNSET:
            field_dict["value"] = value
        if alarming is not UNSET:
            field_dict["alarming"] = alarming
        if current_value is not UNSET:
            field_dict["current_value"] = current_value
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if updater_id is not UNSET:
            field_dict["updater_id"] = updater_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        grant_id = d.pop("grant_id")

        element_id = d.pop("element_id")

        def _parse_spectrum_id(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        spectrum_id = _parse_spectrum_id(d.pop("spectrum_id"))

        name = d.pop("name")

        metric = d.pop("metric")

        comparator = d.pop("comparator")

        threshold = d.pop("threshold")

        id = d.pop("id", UNSET)

        def _parse_rt_int_constraint_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        rt_int_constraint_id = _parse_rt_int_constraint_id(
            d.pop("rt_int_constraint_id", UNSET)
        )

        def _parse_aggregator(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        aggregator = _parse_aggregator(d.pop("aggregator", UNSET))

        def _parse_period(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        period = _parse_period(d.pop("period", UNSET))

        value = d.pop("value", UNSET)

        def _parse_alarming(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        alarming = _parse_alarming(d.pop("alarming", UNSET))

        current_value = d.pop("current_value", UNSET)

        creator_id = d.pop("creator_id", UNSET)

        def _parse_updater_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        updater_id = _parse_updater_id(d.pop("updater_id", UNSET))

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_updated_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                updated_at_type_0 = isoparse(data)

                return updated_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        updated_at = _parse_updated_at(d.pop("updated_at", UNSET))

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        grant_alarm = cls(
            grant_id=grant_id,
            element_id=element_id,
            spectrum_id=spectrum_id,
            name=name,
            metric=metric,
            comparator=comparator,
            threshold=threshold,
            id=id,
            rt_int_constraint_id=rt_int_constraint_id,
            aggregator=aggregator,
            period=period,
            value=value,
            alarming=alarming,
            current_value=current_value,
            creator_id=creator_id,
            updater_id=updater_id,
            created_at=created_at,
            updated_at=updated_at,
            deleted_at=deleted_at,
        )

        grant_alarm.additional_properties = d
        return grant_alarm

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
