import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.grant_alarm_list import GrantAlarmList
from ...models.list_alarm_grants_end_field import ListAlarmGrantsEndField
from ...models.list_alarm_grants_kind import ListAlarmGrantsKind
from ...models.list_alarm_grants_sort import ListAlarmGrantsSort
from ...models.list_alarm_grants_start_field import ListAlarmGrantsStartField
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    element_id: Union[Unset, str] = UNSET,
    spectrum_id: Union[Unset, str] = UNSET,
    name: Union[Unset, str] = UNSET,
    alarming: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListAlarmGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListAlarmGrantsEndField] = UNSET,
    sort: Union[Unset, ListAlarmGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    kind: Union[Unset, ListAlarmGrantsKind] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["element_id"] = element_id

    params["spectrum_id"] = spectrum_id

    params["name"] = name

    params["alarming"] = alarming

    params["deleted"] = deleted

    params["include_deleted"] = include_deleted

    json_include_deleted_after: Union[Unset, str] = UNSET
    if not isinstance(include_deleted_after, Unset):
        json_include_deleted_after = include_deleted_after.isoformat()
    params["include_deleted_after"] = json_include_deleted_after

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/alarms/grants",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, GrantAlarmList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = GrantAlarmList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, GrantAlarmList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    spectrum_id: Union[Unset, str] = UNSET,
    name: Union[Unset, str] = UNSET,
    alarming: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListAlarmGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListAlarmGrantsEndField] = UNSET,
    sort: Union[Unset, ListAlarmGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    kind: Union[Unset, ListAlarmGrantsKind] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, GrantAlarmList]]:
    """Retrieve a list of active grant alarms.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        spectrum_id (Union[Unset, str]): Filters by spectrum_id.
        name (Union[Unset, str]): Filters by observation description.
        alarming (Union[Unset, bool]): If true, show only alarming alarm grants.
        deleted (Union[Unset, bool]): If true, show only deleted alarm grants. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListAlarmGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListAlarmGrantsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListAlarmGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        kind (Union[Unset, ListAlarmGrantsKind]):
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, GrantAlarmList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        spectrum_id=spectrum_id,
        name=name,
        alarming=alarming,
        deleted=deleted,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        kind=kind,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    spectrum_id: Union[Unset, str] = UNSET,
    name: Union[Unset, str] = UNSET,
    alarming: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListAlarmGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListAlarmGrantsEndField] = UNSET,
    sort: Union[Unset, ListAlarmGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    kind: Union[Unset, ListAlarmGrantsKind] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, GrantAlarmList]]:
    """Retrieve a list of active grant alarms.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        spectrum_id (Union[Unset, str]): Filters by spectrum_id.
        name (Union[Unset, str]): Filters by observation description.
        alarming (Union[Unset, bool]): If true, show only alarming alarm grants.
        deleted (Union[Unset, bool]): If true, show only deleted alarm grants. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListAlarmGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListAlarmGrantsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListAlarmGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        kind (Union[Unset, ListAlarmGrantsKind]):
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, GrantAlarmList]
    """

    return sync_detailed(
        client=client,
        element_id=element_id,
        spectrum_id=spectrum_id,
        name=name,
        alarming=alarming,
        deleted=deleted,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        kind=kind,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    spectrum_id: Union[Unset, str] = UNSET,
    name: Union[Unset, str] = UNSET,
    alarming: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListAlarmGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListAlarmGrantsEndField] = UNSET,
    sort: Union[Unset, ListAlarmGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    kind: Union[Unset, ListAlarmGrantsKind] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, GrantAlarmList]]:
    """Retrieve a list of active grant alarms.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        spectrum_id (Union[Unset, str]): Filters by spectrum_id.
        name (Union[Unset, str]): Filters by observation description.
        alarming (Union[Unset, bool]): If true, show only alarming alarm grants.
        deleted (Union[Unset, bool]): If true, show only deleted alarm grants. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListAlarmGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListAlarmGrantsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListAlarmGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        kind (Union[Unset, ListAlarmGrantsKind]):
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, GrantAlarmList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        spectrum_id=spectrum_id,
        name=name,
        alarming=alarming,
        deleted=deleted,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        kind=kind,
        page=page,
        items_per_page=items_per_page,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    client: AuthenticatedClient,
    *,
    element_id: Union[Unset, str] = UNSET,
    spectrum_id: Union[Unset, str] = UNSET,
    name: Union[Unset, str] = UNSET,
    alarming: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListAlarmGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListAlarmGrantsEndField] = UNSET,
    sort: Union[Unset, ListAlarmGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    kind: Union[Unset, ListAlarmGrantsKind] = UNSET,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, GrantAlarmList]]:
    """Retrieve a list of active grant alarms.

    Args:
        element_id (Union[Unset, str]): Filters by element_id; caller must have a role in the
            target element_id.  Required if you are not an admin.
        spectrum_id (Union[Unset, str]): Filters by spectrum_id.
        name (Union[Unset, str]): Filters by observation description.
        alarming (Union[Unset, bool]): If true, show only alarming alarm grants.
        deleted (Union[Unset, bool]): If true, show only deleted alarm grants. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListAlarmGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListAlarmGrantsEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListAlarmGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        kind (Union[Unset, ListAlarmGrantsKind]):
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, GrantAlarmList]
    """

    return (
        await asyncio_detailed(
            client=client,
            element_id=element_id,
            spectrum_id=spectrum_id,
            name=name,
            alarming=alarming,
            deleted=deleted,
            include_deleted=include_deleted,
            include_deleted_after=include_deleted_after,
            start=start,
            start_field=start_field,
            end=end,
            end_field=end_field,
            sort=sort,
            sort_asc=sort_asc,
            kind=kind,
            page=page,
            items_per_page=items_per_page,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
