<!--
SPDX-FileCopyrightText: 2024-present University of Utah <info@openzms.org>
SPDX-License-Identifier: Apache-2.0
-->

# zms-client-py (OpenZMS Python 3 API client library and CLI tools)

The [OpenZMS software](https://gitlab.flux.utah.edu/openzms) is a prototype
automatic spectrum-sharing and -management system for radio dynamic zones.
OpenZMS provides mechanisms to share electromagnetic (radio-frequency)
spectrum between experimental or test systems and existing spectrum users,
and between multiple experimental systems.  We are building and deploying
OpenZMS within the context of the POWDER wireless testbed in Salt Lake City,
Utah, part of the NSF-sponsored Platforms for Advanced Wireless Research
program, to create [POWDER-RDZ](https://rdz.powderwireless.net).

This repository contains a OpenZMS Python 3 API client library based on API
bindings (models and API function wrappers) automatically generated from
each OpenZMS service's `openapi` specification.  Bindings are generated using
[our fork](https://gitlab.flux.utah.edu/openzms/openapi-python-client) of
`openapi-python-client`, which has additional support for some of the
`openapi` extension attributes we provide to help generators create better
code.

This repository also provides a [`typer`](https://typer.tiangolo.com/)-based
dynamically-generated CLI tool.  On invocation, the CLI tool scans a subset
of the generated API function wrappers and uses a combination of `typer` and
`click` to wrap them into a CLI tool that exposes each API endpoint as a
subcommand.

Autogenerated API documentation is available at
http://openzms.pages.flux.utah.edu/zms-client-py .


## Installing from source

Most likely you will want to install this library and its tools with
`virtualenv` (drop the `'[cli]'` if you don't require the CLI):

```
python -m venv path/to/your/venv
. path/to/your/venv/bin/activate
pip install .'[cli]'
```

Then you can run `zmsclient-cli --help`, or use the library.  Leave the
`virtualenv` via `deactivate`.

You can also install locally with `pip`:

```
pip install --user .'[cli]'
```

## Using via prebuilt Docker images

If you simply want to run the `zmsclient-cli` or the associated command-line
tools, you can use the
[CI-built Docker images](https://gitlab.flux.utah.edu/openzms/zms-client-py/container_registry/52):

```
docker run --rm -it gitlab.flux.utah.edu:4567/openzms/zms-client-py/zmsclient:dev zmsclient-cli --help
```

You can use the `docker/Dockerfile` as a base or starting point for
including `zms-client-py` in your own Python package or app.


## Install from Ubuntu Packages

We provide packages for Ubuntu 22 and 24 at
https://repos.emulab.net/openzms-testing/ubuntu .  These are CI-built via
https://gitlab.flux.utah.edu/openzms/zms-client-py-deb .
