import datetime
from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.monitor_status import MonitorStatus
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.any_object import AnyObject


T = TypeVar("T", bound="MonitorPending")


@_attrs_define
class MonitorPending:
    """Represents a next state change instruction that the OpenZMS monitor controller provides to the monitor.

    Attributes:
        id (Union[Unset, str]): The id of the monitor pending state resource.
        monitor_id (Union[Unset, str]): The id of the monitor.
        status (Union[Unset, MonitorStatus]): The status of the monitor.  This field is determined by the OpenZMS
            monitor controller, and cannot be set by non-administrator users.
        status_ack_by (Union[None, Unset, datetime.datetime]): The time by which the next heartbeat for this monitor is
            required, if any.  When heartbeats are enforced, OpenZMS will require periodic monitor status updates.  This
            field is determined by the OpenZMS monitor controller, and cannot be set by users.
        parameters (Union[None, Unset, AnyObject]):
        creator_id (Union[Unset, str]): The user id of the creator.
        created_at (Union[Unset, datetime.datetime]): Creation time.
    """

    id: Union[Unset, str] = UNSET
    monitor_id: Union[Unset, str] = UNSET
    status: Union[Unset, MonitorStatus] = UNSET
    status_ack_by: Union[None, Unset, datetime.datetime] = UNSET
    parameters: Union[None, Unset, "AnyObject"] = UNSET
    creator_id: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "monitor_id": {"put": True, "post": True},
        "status": {"put": True, "post": None},
        "status_ack_by": {"put": True, "post": True},
        "parameters": {"put": None, "post": None},
        "creator_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        monitor_id = self.monitor_id

        status: Union[Unset, str] = UNSET
        if not isinstance(self.status, Unset):
            status = self.status.value

        status_ack_by: Union[None, Unset, str]
        if isinstance(self.status_ack_by, Unset):
            status_ack_by = UNSET
        elif isinstance(self.status_ack_by, datetime.datetime):
            status_ack_by = self.status_ack_by.isoformat()
        else:
            status_ack_by = self.status_ack_by

        parameters: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.parameters is None:
            parameters = None
        elif not isinstance(self.parameters, Unset):
            parameters = self.parameters.to_dict()

        creator_id = self.creator_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if monitor_id is not UNSET:
            field_dict["monitor_id"] = monitor_id
        if status is not UNSET:
            field_dict["status"] = status
        if status_ack_by is not UNSET:
            field_dict["status_ack_by"] = status_ack_by
        if parameters is not UNSET:
            field_dict["parameters"] = parameters
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.any_object import AnyObject

        d = src_dict.copy()
        id = d.pop("id", UNSET)

        monitor_id = d.pop("monitor_id", UNSET)

        _status = d.pop("status", UNSET)
        status: Union[Unset, MonitorStatus]
        if isinstance(_status, Unset):
            status = UNSET
        else:
            status = MonitorStatus(_status)

        def _parse_status_ack_by(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                status_ack_by_type_0 = isoparse(data)

                return status_ack_by_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        status_ack_by = _parse_status_ack_by(d.pop("status_ack_by", UNSET))

        _parameters = d.pop("parameters", UNSET)
        parameters: Union[None, Unset, AnyObject]
        if isinstance(_parameters, Unset):
            parameters = UNSET
        elif _parameters is None:
            parameters = None
        else:
            parameters = AnyObject.from_dict(_parameters)

        creator_id = d.pop("creator_id", UNSET)

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        monitor_pending = cls(
            id=id,
            monitor_id=monitor_id,
            status=status,
            status_ack_by=status_ack_by,
            parameters=parameters,
            creator_id=creator_id,
            created_at=created_at,
        )

        monitor_pending.additional_properties = d
        return monitor_pending

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.any_object import AnyObject

    ns["AnyObject"] = AnyObject
