from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_monitor_actions_sort import ListMonitorActionsSort
from ...models.monitor_action_list import MonitorActionList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    monitor_id: str,
    *,
    monitor_action: Union[Unset, str] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListMonitorActionsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    headers["X-Api-Token"] = x_api_token

    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["monitor_action"] = monitor_action

    params["deleted"] = deleted

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/monitors/{monitor_id}/actions".format(
            monitor_id=monitor_id,
        ),
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, MonitorActionList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = MonitorActionList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.NOT_FOUND:
        try:
            response_404 = Error.from_dict(response.json())

            return response_404
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, MonitorActionList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    monitor_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    monitor_action: Union[Unset, str] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListMonitorActionsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, MonitorActionList]]:
    """Retrieve the current action list for a specific monitor.

    Args:
        monitor_id (str): The target monitor.
        monitor_action (Union[Unset, str]): Filter over name and description fields.
        deleted (Union[Unset, bool]): If true, show only deleted monitor actions. Default: False.
        sort (Union[Unset, ListMonitorActionsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, MonitorActionList]]
    """

    kwargs = _get_kwargs(
        monitor_id=monitor_id,
        monitor_action=monitor_action,
        deleted=deleted,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    monitor_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    monitor_action: Union[Unset, str] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListMonitorActionsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, MonitorActionList]]:
    """Retrieve the current action list for a specific monitor.

    Args:
        monitor_id (str): The target monitor.
        monitor_action (Union[Unset, str]): Filter over name and description fields.
        deleted (Union[Unset, bool]): If true, show only deleted monitor actions. Default: False.
        sort (Union[Unset, ListMonitorActionsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, MonitorActionList]
    """

    return sync_detailed(
        monitor_id=monitor_id,
        client=client,
        monitor_action=monitor_action,
        deleted=deleted,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    monitor_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    monitor_action: Union[Unset, str] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListMonitorActionsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, MonitorActionList]]:
    """Retrieve the current action list for a specific monitor.

    Args:
        monitor_id (str): The target monitor.
        monitor_action (Union[Unset, str]): Filter over name and description fields.
        deleted (Union[Unset, bool]): If true, show only deleted monitor actions. Default: False.
        sort (Union[Unset, ListMonitorActionsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, MonitorActionList]]
    """

    kwargs = _get_kwargs(
        monitor_id=monitor_id,
        monitor_action=monitor_action,
        deleted=deleted,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    monitor_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    monitor_action: Union[Unset, str] = UNSET,
    deleted: Union[Unset, bool] = False,
    sort: Union[Unset, ListMonitorActionsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, MonitorActionList]]:
    """Retrieve the current action list for a specific monitor.

    Args:
        monitor_id (str): The target monitor.
        monitor_action (Union[Unset, str]): Filter over name and description fields.
        deleted (Union[Unset, bool]): If true, show only deleted monitor actions. Default: False.
        sort (Union[Unset, ListMonitorActionsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, MonitorActionList]
    """

    return (
        await asyncio_detailed(
            monitor_id=monitor_id,
            client=client,
            monitor_action=monitor_action,
            deleted=deleted,
            sort=sort,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_token=x_api_token,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
