from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.influx_d_bv_1_query_response_statement_series import (
        InfluxDBv1QueryResponseStatementSeries,
    )


T = TypeVar("T", bound="InfluxDBv1QueryResponseStatement")


@_attrs_define
class InfluxDBv1QueryResponseStatement:
    """The result of a single InfluxDB v1 query statement.

    Attributes:
        statement_id (int): The zero-based index of the statement in the query.
        series (Union[Unset, List['InfluxDBv1QueryResponseStatementSeries']]): The list of series returned by the query,
            if any.
    """

    statement_id: int
    series: Union[Unset, List["InfluxDBv1QueryResponseStatementSeries"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "statement_id": {"put": None, "post": None},
        "series": {"put": None, "post": None},
    }

    def to_dict(self) -> Dict[str, Any]:
        statement_id = self.statement_id

        series: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.series, Unset):
            series = []
            for series_item_data in self.series:
                series_item = series_item_data.to_dict()
                series.append(series_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "statement_id": statement_id,
            }
        )
        if series is not UNSET:
            field_dict["series"] = series

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.influx_d_bv_1_query_response_statement_series import (
            InfluxDBv1QueryResponseStatementSeries,
        )

        d = src_dict.copy()
        statement_id = d.pop("statement_id")

        series = []
        _series = d.pop("series", UNSET)
        for series_item_data in _series or []:
            series_item = InfluxDBv1QueryResponseStatementSeries.from_dict(
                series_item_data
            )

            series.append(series_item)

        influx_d_bv_1_query_response_statement = cls(
            statement_id=statement_id,
            series=series,
        )

        influx_d_bv_1_query_response_statement.additional_properties = d
        return influx_d_bv_1_query_response_statement

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.influx_d_bv_1_query_response_statement_series import (
        InfluxDBv1QueryResponseStatementSeries,
    )

    ns["InfluxDBv1QueryResponseStatementSeries"] = (
        InfluxDBv1QueryResponseStatementSeries
    )
