import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.list_series_values_internal_end_field import (
    ListSeriesValuesInternalEndField,
)
from ...models.list_series_values_internal_kind import ListSeriesValuesInternalKind
from ...models.list_series_values_internal_sort import ListSeriesValuesInternalSort
from ...models.list_series_values_internal_start_field import (
    ListSeriesValuesInternalStartField,
)
from ...models.value_list import ValueList
from ...types import UNSET, Response, Unset


def _get_kwargs(
    series_id: str,
    *,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListSeriesValuesInternalStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListSeriesValuesInternalKind] = UNSET,
    end_field: Union[Unset, ListSeriesValuesInternalEndField] = UNSET,
    sort: Union[Unset, ListSeriesValuesInternalSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    headers["X-Api-Token"] = x_api_token

    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/series/{series_id}/values/internal".format(
            series_id=series_id,
        ),
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, ValueList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = ValueList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.NOT_FOUND:
        try:
            response_404 = Error.from_dict(response.json())

            return response_404
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, ValueList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    series_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListSeriesValuesInternalStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListSeriesValuesInternalKind] = UNSET,
    end_field: Union[Unset, ListSeriesValuesInternalEndField] = UNSET,
    sort: Union[Unset, ListSeriesValuesInternalSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, ValueList]]:
    """Retrieve a list of values for a specific series.  If the series store is not `internal`, an error is
    returned.

    Args:
        series_id (str): The target series.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListSeriesValuesInternalStartField]): Name of field used in
            start time comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListSeriesValuesInternalKind]):
        end_field (Union[Unset, ListSeriesValuesInternalEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListSeriesValuesInternalSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, ValueList]]
    """

    kwargs = _get_kwargs(
        series_id=series_id,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    series_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListSeriesValuesInternalStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListSeriesValuesInternalKind] = UNSET,
    end_field: Union[Unset, ListSeriesValuesInternalEndField] = UNSET,
    sort: Union[Unset, ListSeriesValuesInternalSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, ValueList]]:
    """Retrieve a list of values for a specific series.  If the series store is not `internal`, an error is
    returned.

    Args:
        series_id (str): The target series.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListSeriesValuesInternalStartField]): Name of field used in
            start time comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListSeriesValuesInternalKind]):
        end_field (Union[Unset, ListSeriesValuesInternalEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListSeriesValuesInternalSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, ValueList]
    """

    return sync_detailed(
        series_id=series_id,
        client=client,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    series_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListSeriesValuesInternalStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListSeriesValuesInternalKind] = UNSET,
    end_field: Union[Unset, ListSeriesValuesInternalEndField] = UNSET,
    sort: Union[Unset, ListSeriesValuesInternalSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, ValueList]]:
    """Retrieve a list of values for a specific series.  If the series store is not `internal`, an error is
    returned.

    Args:
        series_id (str): The target series.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListSeriesValuesInternalStartField]): Name of field used in
            start time comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListSeriesValuesInternalKind]):
        end_field (Union[Unset, ListSeriesValuesInternalEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListSeriesValuesInternalSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, ValueList]]
    """

    kwargs = _get_kwargs(
        series_id=series_id,
        start=start,
        start_field=start_field,
        end=end,
        kind=kind,
        end_field=end_field,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    series_id: str,
    *,
    client: Union[AuthenticatedClient, Client],
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListSeriesValuesInternalStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    kind: Union[Unset, ListSeriesValuesInternalKind] = UNSET,
    end_field: Union[Unset, ListSeriesValuesInternalEndField] = UNSET,
    sort: Union[Unset, ListSeriesValuesInternalSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, ValueList]]:
    """Retrieve a list of values for a specific series.  If the series store is not `internal`, an error is
    returned.

    Args:
        series_id (str): The target series.
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListSeriesValuesInternalStartField]): Name of field used in
            start time comparison.
        end (Union[Unset, datetime.datetime]):
        kind (Union[Unset, ListSeriesValuesInternalKind]):
        end_field (Union[Unset, ListSeriesValuesInternalEndField]): Name of field used in end time
            comparison.
        sort (Union[Unset, ListSeriesValuesInternalSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, ValueList]
    """

    return (
        await asyncio_detailed(
            series_id=series_id,
            client=client,
            start=start,
            start_field=start_field,
            end=end,
            kind=kind,
            end_field=end_field,
            sort=sort,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_token=x_api_token,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
