import datetime
from typing import (
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="MonitorTaskState")


@_attrs_define
class MonitorTaskState:
    """The state of a monitor task.

    Attributes:
        runnable (bool): Set `true` if the task is runnable (scheduled or running).
        finished (bool): Set `true` if the task is finished (successfully or unsuccessfully).
        error (bool): Set `true` if the task has experienced an error and is not runnable.
        id (Union[Unset, str]): The id of the monitor task state resource.
        monitor_task_id (Union[Unset, str]): The id of the associated monitor task.
        next_start (Union[None, Unset, datetime.datetime]): The next-scheduled start time, if any.
        next_duration (Union[None, Unset, float]): The next-scheduled duration time, if any.
        status (Union[None, Unset, str]): A return value from the task; monitor-specific; optional.  Could be used to
            communicate a specific error value.
        message (Union[None, Unset, str]): A return message from the task; monitor-specific; optional.  Should be used
            to communicate an error message.
        updated_at (Union[Unset, datetime.datetime]): Last update time.
    """

    runnable: bool
    finished: bool
    error: bool
    id: Union[Unset, str] = UNSET
    monitor_task_id: Union[Unset, str] = UNSET
    next_start: Union[None, Unset, datetime.datetime] = UNSET
    next_duration: Union[None, Unset, float] = UNSET
    status: Union[None, Unset, str] = UNSET
    message: Union[None, Unset, str] = UNSET
    updated_at: Union[Unset, datetime.datetime] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "monitor_task_id": {"put": True, "post": True},
        "runnable": {"put": None, "post": None},
        "finished": {"put": None, "post": None},
        "error": {"put": None, "post": None},
        "next_start": {"put": None, "post": None},
        "next_duration": {"put": None, "post": None},
        "status": {"put": None, "post": None},
        "message": {"put": None, "post": None},
        "updated_at": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        runnable = self.runnable

        finished = self.finished

        error = self.error

        id = self.id

        monitor_task_id = self.monitor_task_id

        next_start: Union[None, Unset, str]
        if isinstance(self.next_start, Unset):
            next_start = UNSET
        elif isinstance(self.next_start, datetime.datetime):
            next_start = self.next_start.isoformat()
        else:
            next_start = self.next_start

        next_duration: Union[None, Unset, float]
        if isinstance(self.next_duration, Unset):
            next_duration = UNSET
        else:
            next_duration = self.next_duration

        status: Union[None, Unset, str]
        if isinstance(self.status, Unset):
            status = UNSET
        else:
            status = self.status

        message: Union[None, Unset, str]
        if isinstance(self.message, Unset):
            message = UNSET
        else:
            message = self.message

        updated_at: Union[Unset, str] = UNSET
        if not isinstance(self.updated_at, Unset):
            updated_at = self.updated_at.isoformat()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "runnable": runnable,
                "finished": finished,
                "error": error,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if monitor_task_id is not UNSET:
            field_dict["monitor_task_id"] = monitor_task_id
        if next_start is not UNSET:
            field_dict["next_start"] = next_start
        if next_duration is not UNSET:
            field_dict["next_duration"] = next_duration
        if status is not UNSET:
            field_dict["status"] = status
        if message is not UNSET:
            field_dict["message"] = message
        if updated_at is not UNSET:
            field_dict["updated_at"] = updated_at

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        runnable = d.pop("runnable")

        finished = d.pop("finished")

        error = d.pop("error")

        id = d.pop("id", UNSET)

        monitor_task_id = d.pop("monitor_task_id", UNSET)

        def _parse_next_start(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                next_start_type_0 = isoparse(data)

                return next_start_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        next_start = _parse_next_start(d.pop("next_start", UNSET))

        def _parse_next_duration(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        next_duration = _parse_next_duration(d.pop("next_duration", UNSET))

        def _parse_status(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        status = _parse_status(d.pop("status", UNSET))

        def _parse_message(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        message = _parse_message(d.pop("message", UNSET))

        _updated_at = d.pop("updated_at", UNSET)
        updated_at: Union[Unset, datetime.datetime]
        if isinstance(_updated_at, Unset):
            updated_at = UNSET
        else:
            updated_at = isoparse(_updated_at)

        monitor_task_state = cls(
            runnable=runnable,
            finished=finished,
            error=error,
            id=id,
            monitor_task_id=monitor_task_id,
            next_start=next_start,
            next_duration=next_duration,
            status=status,
            message=message,
            updated_at=updated_at,
        )

        monitor_task_state.additional_properties = d
        return monitor_task_state

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    pass
