import datetime
from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.error import Error
from ...models.grant_list import GrantList
from ...models.list_grants_end_field import ListGrantsEndField
from ...models.list_grants_kind import ListGrantsKind
from ...models.list_grants_sort import ListGrantsSort
from ...models.list_grants_start_field import ListGrantsStartField
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    element_id: Union[Unset, str] = UNSET,
    grant: Union[Unset, str] = UNSET,
    ext_id: Union[Unset, str] = UNSET,
    approved: Union[Unset, bool] = UNSET,
    owner_approved: Union[Unset, bool] = UNSET,
    current: Union[Unset, bool] = UNSET,
    denied: Union[Unset, bool] = UNSET,
    revoked: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    claim: Union[Unset, bool] = False,
    include_claims: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListGrantsEndField] = UNSET,
    kind: Union[Unset, ListGrantsKind] = UNSET,
    sort: Union[Unset, ListGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Dict[str, Any]:
    headers: Dict[str, Any] = {}
    headers["X-Api-Token"] = x_api_token

    if not isinstance(x_api_elaborate, Unset):
        headers["X-Api-Elaborate"] = x_api_elaborate

    params: Dict[str, Any] = {}

    params["element_id"] = element_id

    params["grant"] = grant

    params["ext_id"] = ext_id

    params["approved"] = approved

    params["owner_approved"] = owner_approved

    params["current"] = current

    params["denied"] = denied

    params["revoked"] = revoked

    params["deleted"] = deleted

    params["claim"] = claim

    params["include_claims"] = include_claims

    params["include_deleted"] = include_deleted

    json_include_deleted_after: Union[Unset, str] = UNSET
    if not isinstance(include_deleted_after, Unset):
        json_include_deleted_after = include_deleted_after.isoformat()
    params["include_deleted_after"] = json_include_deleted_after

    json_start: Union[Unset, str] = UNSET
    if not isinstance(start, Unset):
        json_start = start.isoformat()
    params["start"] = json_start

    json_start_field: Union[Unset, str] = UNSET
    if not isinstance(start_field, Unset):
        json_start_field = start_field.value

    params["start_field"] = json_start_field

    json_end: Union[Unset, str] = UNSET
    if not isinstance(end, Unset):
        json_end = end.isoformat()
    params["end"] = json_end

    json_end_field: Union[Unset, str] = UNSET
    if not isinstance(end_field, Unset):
        json_end_field = end_field.value

    params["end_field"] = json_end_field

    json_kind: Union[Unset, str] = UNSET
    if not isinstance(kind, Unset):
        json_kind = kind.value

    params["kind"] = json_kind

    json_sort: Union[Unset, str] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params["sort"] = json_sort

    params["sort_asc"] = sort_asc

    params["page"] = page

    params["items_per_page"] = items_per_page

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: Dict[str, Any] = {
        "method": "get",
        "url": "/grants",
        "params": params,
    }

    _kwargs["headers"] = headers
    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Error, GrantList]]:
    if response.status_code == HTTPStatus.OK:
        try:
            response_200 = GrantList.from_dict(response.json())

            return response_200
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.BAD_REQUEST:
        try:
            response_400 = Error.from_dict(response.json())

            return response_400
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.UNAUTHORIZED:
        try:
            response_401 = Error.from_dict(response.json())

            return response_401
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if response.status_code == HTTPStatus.FORBIDDEN:
        try:
            response_403 = Error.from_dict(response.json())

            return response_403
        except Exception:
            if client.raise_on_undecodable_content:
                raise errors.UndecodableContent(
                    response.status_code, response.content, response
                )
            else:
                raise
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content, response)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Error, GrantList]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    grant: Union[Unset, str] = UNSET,
    ext_id: Union[Unset, str] = UNSET,
    approved: Union[Unset, bool] = UNSET,
    owner_approved: Union[Unset, bool] = UNSET,
    current: Union[Unset, bool] = UNSET,
    denied: Union[Unset, bool] = UNSET,
    revoked: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    claim: Union[Unset, bool] = False,
    include_claims: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListGrantsEndField] = UNSET,
    kind: Union[Unset, ListGrantsKind] = UNSET,
    sort: Union[Unset, ListGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, GrantList]]:
    """Retrieve a list of grants.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        grant (Union[Unset, str]): Filters by grant name or description.
        ext_id (Union[Unset, str]): Filters by grant ext_id.
        approved (Union[Unset, bool]): If true, show only approved grants.
        owner_approved (Union[Unset, bool]): If true, show only owner_approved grants.
        current (Union[Unset, bool]): If true, show only current grants.
        denied (Union[Unset, bool]): If true, show only denied grants.
        revoked (Union[Unset, bool]): If true, show only revoked grants.
        deleted (Union[Unset, bool]): If true, show only deleted grants. Default: False.
        claim (Union[Unset, bool]): If true, show only grants that are associated with Claims.
            Default: False.
        include_claims (Union[Unset, bool]): If true, include both claims and grants; overrides
            the value of the claim parameter if set. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListGrantsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListGrantsKind]):
        sort (Union[Unset, ListGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, GrantList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        grant=grant,
        ext_id=ext_id,
        approved=approved,
        owner_approved=owner_approved,
        current=current,
        denied=denied,
        revoked=revoked,
        deleted=deleted,
        claim=claim,
        include_claims=include_claims,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    grant: Union[Unset, str] = UNSET,
    ext_id: Union[Unset, str] = UNSET,
    approved: Union[Unset, bool] = UNSET,
    owner_approved: Union[Unset, bool] = UNSET,
    current: Union[Unset, bool] = UNSET,
    denied: Union[Unset, bool] = UNSET,
    revoked: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    claim: Union[Unset, bool] = False,
    include_claims: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListGrantsEndField] = UNSET,
    kind: Union[Unset, ListGrantsKind] = UNSET,
    sort: Union[Unset, ListGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, GrantList]]:
    """Retrieve a list of grants.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        grant (Union[Unset, str]): Filters by grant name or description.
        ext_id (Union[Unset, str]): Filters by grant ext_id.
        approved (Union[Unset, bool]): If true, show only approved grants.
        owner_approved (Union[Unset, bool]): If true, show only owner_approved grants.
        current (Union[Unset, bool]): If true, show only current grants.
        denied (Union[Unset, bool]): If true, show only denied grants.
        revoked (Union[Unset, bool]): If true, show only revoked grants.
        deleted (Union[Unset, bool]): If true, show only deleted grants. Default: False.
        claim (Union[Unset, bool]): If true, show only grants that are associated with Claims.
            Default: False.
        include_claims (Union[Unset, bool]): If true, include both claims and grants; overrides
            the value of the claim parameter if set. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListGrantsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListGrantsKind]):
        sort (Union[Unset, ListGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, GrantList]
    """

    return sync_detailed(
        client=client,
        element_id=element_id,
        grant=grant,
        ext_id=ext_id,
        approved=approved,
        owner_approved=owner_approved,
        current=current,
        denied=denied,
        revoked=revoked,
        deleted=deleted,
        claim=claim,
        include_claims=include_claims,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    ).parsed


async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    grant: Union[Unset, str] = UNSET,
    ext_id: Union[Unset, str] = UNSET,
    approved: Union[Unset, bool] = UNSET,
    owner_approved: Union[Unset, bool] = UNSET,
    current: Union[Unset, bool] = UNSET,
    denied: Union[Unset, bool] = UNSET,
    revoked: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    claim: Union[Unset, bool] = False,
    include_claims: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListGrantsEndField] = UNSET,
    kind: Union[Unset, ListGrantsKind] = UNSET,
    sort: Union[Unset, ListGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Response[Union[Error, GrantList]]:
    """Retrieve a list of grants.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        grant (Union[Unset, str]): Filters by grant name or description.
        ext_id (Union[Unset, str]): Filters by grant ext_id.
        approved (Union[Unset, bool]): If true, show only approved grants.
        owner_approved (Union[Unset, bool]): If true, show only owner_approved grants.
        current (Union[Unset, bool]): If true, show only current grants.
        denied (Union[Unset, bool]): If true, show only denied grants.
        revoked (Union[Unset, bool]): If true, show only revoked grants.
        deleted (Union[Unset, bool]): If true, show only deleted grants. Default: False.
        claim (Union[Unset, bool]): If true, show only grants that are associated with Claims.
            Default: False.
        include_claims (Union[Unset, bool]): If true, include both claims and grants; overrides
            the value of the claim parameter if set. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListGrantsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListGrantsKind]):
        sort (Union[Unset, ListGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Error, GrantList]]
    """

    kwargs = _get_kwargs(
        element_id=element_id,
        grant=grant,
        ext_id=ext_id,
        approved=approved,
        owner_approved=owner_approved,
        current=current,
        denied=denied,
        revoked=revoked,
        deleted=deleted,
        claim=claim,
        include_claims=include_claims,
        include_deleted=include_deleted,
        include_deleted_after=include_deleted_after,
        start=start,
        start_field=start_field,
        end=end,
        end_field=end_field,
        kind=kind,
        sort=sort,
        sort_asc=sort_asc,
        page=page,
        items_per_page=items_per_page,
        x_api_token=x_api_token,
        x_api_elaborate=x_api_elaborate,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    element_id: Union[Unset, str] = UNSET,
    grant: Union[Unset, str] = UNSET,
    ext_id: Union[Unset, str] = UNSET,
    approved: Union[Unset, bool] = UNSET,
    owner_approved: Union[Unset, bool] = UNSET,
    current: Union[Unset, bool] = UNSET,
    denied: Union[Unset, bool] = UNSET,
    revoked: Union[Unset, bool] = UNSET,
    deleted: Union[Unset, bool] = False,
    claim: Union[Unset, bool] = False,
    include_claims: Union[Unset, bool] = False,
    include_deleted: Union[Unset, bool] = UNSET,
    include_deleted_after: Union[Unset, datetime.datetime] = UNSET,
    start: Union[Unset, datetime.datetime] = UNSET,
    start_field: Union[Unset, ListGrantsStartField] = UNSET,
    end: Union[Unset, datetime.datetime] = UNSET,
    end_field: Union[Unset, ListGrantsEndField] = UNSET,
    kind: Union[Unset, ListGrantsKind] = UNSET,
    sort: Union[Unset, ListGrantsSort] = UNSET,
    sort_asc: Union[Unset, bool] = False,
    page: Union[Unset, int] = UNSET,
    items_per_page: Union[Unset, int] = UNSET,
    x_api_token: str,
    x_api_elaborate: Union[Unset, str] = UNSET,
) -> Optional[Union[Error, GrantList]]:
    """Retrieve a list of grants.

    Args:
        element_id (Union[Unset, str]): Filters by element.
        grant (Union[Unset, str]): Filters by grant name or description.
        ext_id (Union[Unset, str]): Filters by grant ext_id.
        approved (Union[Unset, bool]): If true, show only approved grants.
        owner_approved (Union[Unset, bool]): If true, show only owner_approved grants.
        current (Union[Unset, bool]): If true, show only current grants.
        denied (Union[Unset, bool]): If true, show only denied grants.
        revoked (Union[Unset, bool]): If true, show only revoked grants.
        deleted (Union[Unset, bool]): If true, show only deleted grants. Default: False.
        claim (Union[Unset, bool]): If true, show only grants that are associated with Claims.
            Default: False.
        include_claims (Union[Unset, bool]): If true, include both claims and grants; overrides
            the value of the claim parameter if set. Default: False.
        include_deleted (Union[Unset, bool]):
        include_deleted_after (Union[Unset, datetime.datetime]):
        start (Union[Unset, datetime.datetime]):
        start_field (Union[Unset, ListGrantsStartField]): Name of field used in start time
            comparison.
        end (Union[Unset, datetime.datetime]):
        end_field (Union[Unset, ListGrantsEndField]): Name of field used in end time comparison.
        kind (Union[Unset, ListGrantsKind]):
        sort (Union[Unset, ListGrantsSort]): Sorts by specified field.
        sort_asc (Union[Unset, bool]): If omitted or set `false`, sorts requested sort field in
            descending order.  If set `true`, sorts in ascending order. Default: False.
        page (Union[Unset, int]):
        items_per_page (Union[Unset, int]):
        x_api_token (str):
        x_api_elaborate (Union[Unset, str]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        errors.UndecodableContent: If the server returns undecodable content and Client.raise_on_undecodable_content is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Error, GrantList]
    """

    return (
        await asyncio_detailed(
            client=client,
            element_id=element_id,
            grant=grant,
            ext_id=ext_id,
            approved=approved,
            owner_approved=owner_approved,
            current=current,
            denied=denied,
            revoked=revoked,
            deleted=deleted,
            claim=claim,
            include_claims=include_claims,
            include_deleted=include_deleted,
            include_deleted_after=include_deleted_after,
            start=start,
            start_field=start_field,
            end=end,
            end_field=end_field,
            kind=kind,
            sort=sort,
            sort_asc=sort_asc,
            page=page,
            items_per_page=items_per_page,
            x_api_token=x_api_token,
            x_api_elaborate=x_api_elaborate,
        )
    ).parsed
