from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.propsim_job_output import PropsimJobOutput


T = TypeVar("T", bound="PropsimJobOutputList")


@_attrs_define
class PropsimJobOutputList:
    """
    Attributes:
        page (Union[Unset, int]): The current page of results.
        total (Union[Unset, int]): The total number of records available.
        pages (Union[Unset, int]): The total number of pages available.
        propsim_job_outputs (Union[Unset, List['PropsimJobOutput']]):
    """

    page: Union[Unset, int] = UNSET
    total: Union[Unset, int] = UNSET
    pages: Union[Unset, int] = UNSET
    propsim_job_outputs: Union[Unset, List["PropsimJobOutput"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        propsim_job_outputs: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.propsim_job_outputs, Unset):
            propsim_job_outputs = []
            for propsim_job_outputs_item_data in self.propsim_job_outputs:
                propsim_job_outputs_item = propsim_job_outputs_item_data.to_dict()
                propsim_job_outputs.append(propsim_job_outputs_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if page is not UNSET:
            field_dict["page"] = page
        if total is not UNSET:
            field_dict["total"] = total
        if pages is not UNSET:
            field_dict["pages"] = pages
        if propsim_job_outputs is not UNSET:
            field_dict["propsim_job_outputs"] = propsim_job_outputs

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.propsim_job_output import PropsimJobOutput

        d = src_dict.copy()
        page = d.pop("page", UNSET)

        total = d.pop("total", UNSET)

        pages = d.pop("pages", UNSET)

        propsim_job_outputs = []
        _propsim_job_outputs = d.pop("propsim_job_outputs", UNSET)
        for propsim_job_outputs_item_data in _propsim_job_outputs or []:
            propsim_job_outputs_item = PropsimJobOutput.from_dict(
                propsim_job_outputs_item_data
            )

            propsim_job_outputs.append(propsim_job_outputs_item)

        propsim_job_output_list = cls(
            page=page,
            total=total,
            pages=pages,
            propsim_job_outputs=propsim_job_outputs,
        )

        propsim_job_output_list.additional_properties = d
        return propsim_job_output_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.propsim_job_output import PropsimJobOutput

    ns["PropsimJobOutput"] = PropsimJobOutput
