from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.grant_alarm_log import GrantAlarmLog


T = TypeVar("T", bound="GrantAlarmLogList")


@_attrs_define
class GrantAlarmLogList:
    """
    Attributes:
        page (Union[Unset, int]): The current page of results.
        total (Union[Unset, int]): The total number of records available.
        pages (Union[Unset, int]): The total number of pages available.
        grant_alarm_logs (Union[Unset, List['GrantAlarmLog']]):
    """

    page: Union[Unset, int] = UNSET
    total: Union[Unset, int] = UNSET
    pages: Union[Unset, int] = UNSET
    grant_alarm_logs: Union[Unset, List["GrantAlarmLog"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        grant_alarm_logs: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.grant_alarm_logs, Unset):
            grant_alarm_logs = []
            for grant_alarm_logs_item_data in self.grant_alarm_logs:
                grant_alarm_logs_item = grant_alarm_logs_item_data.to_dict()
                grant_alarm_logs.append(grant_alarm_logs_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if page is not UNSET:
            field_dict["page"] = page
        if total is not UNSET:
            field_dict["total"] = total
        if pages is not UNSET:
            field_dict["pages"] = pages
        if grant_alarm_logs is not UNSET:
            field_dict["grant_alarm_logs"] = grant_alarm_logs

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.grant_alarm_log import GrantAlarmLog

        d = src_dict.copy()
        page = d.pop("page", UNSET)

        total = d.pop("total", UNSET)

        pages = d.pop("pages", UNSET)

        grant_alarm_logs = []
        _grant_alarm_logs = d.pop("grant_alarm_logs", UNSET)
        for grant_alarm_logs_item_data in _grant_alarm_logs or []:
            grant_alarm_logs_item = GrantAlarmLog.from_dict(grant_alarm_logs_item_data)

            grant_alarm_logs.append(grant_alarm_logs_item)

        grant_alarm_log_list = cls(
            page=page,
            total=total,
            pages=pages,
            grant_alarm_logs=grant_alarm_logs,
        )

        grant_alarm_log_list.additional_properties = d
        return grant_alarm_log_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.grant_alarm_log import GrantAlarmLog

    ns["GrantAlarmLog"] = GrantAlarmLog
