import datetime
from typing import (
    TYPE_CHECKING,
    Any,
    Dict,
    List,
    Type,
    TypeVar,
    Union,
    cast,
)

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.action import Action


T = TypeVar("T", bound="MonitorAction")


@_attrs_define
class MonitorAction:
    """An Action associated with and provided by a specific monitor.

    Attributes:
        monitor_id (str): The id of the associated monitor.
        action_id (str): The id of the associated action.
        id (Union[Unset, str]): The id of the monitor action resource.
        creator_id (Union[Unset, str]): The user id of the creator.
        created_at (Union[Unset, datetime.datetime]): Creation time.
        deleted_at (Union[None, Unset, datetime.datetime]): Deletion time.
        action (Union[None, Unset, Action]): An action resource provided by monitors.  Defines inputs and outputs to be
            used in MonitorTasks.
    """

    monitor_id: str
    action_id: str
    id: Union[Unset, str] = UNSET
    creator_id: Union[Unset, str] = UNSET
    created_at: Union[Unset, datetime.datetime] = UNSET
    deleted_at: Union[None, Unset, datetime.datetime] = UNSET
    action: Union[None, Unset, "Action"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {
        "id": {"put": True, "post": True},
        "monitor_id": {"put": True, "post": None},
        "action_id": {"put": True, "post": None},
        "creator_id": {"put": True, "post": True},
        "created_at": {"put": True, "post": True},
        "deleted_at": {"put": True, "post": True},
        "action": {"put": True, "post": True},
    }

    def to_dict(self) -> Dict[str, Any]:
        monitor_id = self.monitor_id

        action_id = self.action_id

        id = self.id

        creator_id = self.creator_id

        created_at: Union[Unset, str] = UNSET
        if not isinstance(self.created_at, Unset):
            created_at = self.created_at.isoformat()

        deleted_at: Union[None, Unset, str]
        if isinstance(self.deleted_at, Unset):
            deleted_at = UNSET
        elif isinstance(self.deleted_at, datetime.datetime):
            deleted_at = self.deleted_at.isoformat()
        else:
            deleted_at = self.deleted_at

        action: Union[None, Unset, Dict[str, Any]] = UNSET
        if self.action is None:
            action = None
        elif not isinstance(self.action, Unset):
            action = self.action.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "monitor_id": monitor_id,
                "action_id": action_id,
            }
        )
        if id is not UNSET:
            field_dict["id"] = id
        if creator_id is not UNSET:
            field_dict["creator_id"] = creator_id
        if created_at is not UNSET:
            field_dict["created_at"] = created_at
        if deleted_at is not UNSET:
            field_dict["deleted_at"] = deleted_at
        if action is not UNSET:
            field_dict["action"] = action

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.action import Action

        d = src_dict.copy()
        monitor_id = d.pop("monitor_id")

        action_id = d.pop("action_id")

        id = d.pop("id", UNSET)

        creator_id = d.pop("creator_id", UNSET)

        _created_at = d.pop("created_at", UNSET)
        created_at: Union[Unset, datetime.datetime]
        if isinstance(_created_at, Unset):
            created_at = UNSET
        else:
            created_at = isoparse(_created_at)

        def _parse_deleted_at(data: object) -> Union[None, Unset, datetime.datetime]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                deleted_at_type_0 = isoparse(data)

                return deleted_at_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, Unset, datetime.datetime], data)

        deleted_at = _parse_deleted_at(d.pop("deleted_at", UNSET))

        _action = d.pop("action", UNSET)
        action: Union[None, Unset, Action]
        if isinstance(_action, Unset):
            action = UNSET
        elif _action is None:
            action = None
        else:
            action = Action.from_dict(_action)

        monitor_action = cls(
            monitor_id=monitor_id,
            action_id=action_id,
            id=id,
            creator_id=creator_id,
            created_at=created_at,
            deleted_at=deleted_at,
            action=action,
        )

        monitor_action.additional_properties = d
        return monitor_action

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.action import Action

    ns["Action"] = Action
