from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.series_grant import SeriesGrant


T = TypeVar("T", bound="SeriesGrantList")


@_attrs_define
class SeriesGrantList:
    """
    Attributes:
        page (Union[Unset, int]): The current page of results.
        total (Union[Unset, int]): The total number of records available.
        pages (Union[Unset, int]): The total number of pages available.
        series_grants (Union[Unset, List['SeriesGrant']]):
    """

    page: Union[Unset, int] = UNSET
    total: Union[Unset, int] = UNSET
    pages: Union[Unset, int] = UNSET
    series_grants: Union[Unset, List["SeriesGrant"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        series_grants: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.series_grants, Unset):
            series_grants = []
            for series_grants_item_data in self.series_grants:
                series_grants_item = series_grants_item_data.to_dict()
                series_grants.append(series_grants_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if page is not UNSET:
            field_dict["page"] = page
        if total is not UNSET:
            field_dict["total"] = total
        if pages is not UNSET:
            field_dict["pages"] = pages
        if series_grants is not UNSET:
            field_dict["series_grants"] = series_grants

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.series_grant import SeriesGrant

        d = src_dict.copy()
        page = d.pop("page", UNSET)

        total = d.pop("total", UNSET)

        pages = d.pop("pages", UNSET)

        series_grants = []
        _series_grants = d.pop("series_grants", UNSET)
        for series_grants_item_data in _series_grants or []:
            series_grants_item = SeriesGrant.from_dict(series_grants_item_data)

            series_grants.append(series_grants_item)

        series_grant_list = cls(
            page=page,
            total=total,
            pages=pages,
            series_grants=series_grants,
        )

        series_grant_list.additional_properties = d
        return series_grant_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.series_grant import SeriesGrant

    ns["SeriesGrant"] = SeriesGrant
