from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.influx_d_bv_1_query_response_statement import (
        InfluxDBv1QueryResponseStatement,
    )


T = TypeVar("T", bound="InfluxDBv1QueryResponse")


@_attrs_define
class InfluxDBv1QueryResponse:
    """The response from an InfluxDB v1 query.

    Attributes:
        results (List['InfluxDBv1QueryResponseStatement']): The list of statement results.
    """

    results: List["InfluxDBv1QueryResponseStatement"]
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {"results": {"put": None, "post": None}}

    def to_dict(self) -> Dict[str, Any]:
        results = []
        for results_item_data in self.results:
            results_item = results_item_data.to_dict()
            results.append(results_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "results": results,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.influx_d_bv_1_query_response_statement import (
            InfluxDBv1QueryResponseStatement,
        )

        d = src_dict.copy()
        results = []
        _results = d.pop("results")
        for results_item_data in _results:
            results_item = InfluxDBv1QueryResponseStatement.from_dict(results_item_data)

            results.append(results_item)

        influx_d_bv_1_query_response = cls(
            results=results,
        )

        influx_d_bv_1_query_response.additional_properties = d
        return influx_d_bv_1_query_response

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.influx_d_bv_1_query_response_statement import (
        InfluxDBv1QueryResponseStatement,
    )

    ns["InfluxDBv1QueryResponseStatement"] = InfluxDBv1QueryResponseStatement
