from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.dataset_series import DatasetSeries


T = TypeVar("T", bound="DatasetSeriesList")


@_attrs_define
class DatasetSeriesList:
    """
    Attributes:
        page (Union[Unset, int]): The current page of results.
        total (Union[Unset, int]): The total number of records available.
        pages (Union[Unset, int]): The total number of pages available.
        dataset_series (Union[Unset, List['DatasetSeries']]):
    """

    page: Union[Unset, int] = UNSET
    total: Union[Unset, int] = UNSET
    pages: Union[Unset, int] = UNSET
    dataset_series: Union[Unset, List["DatasetSeries"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        dataset_series: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.dataset_series, Unset):
            dataset_series = []
            for dataset_series_item_data in self.dataset_series:
                dataset_series_item = dataset_series_item_data.to_dict()
                dataset_series.append(dataset_series_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if page is not UNSET:
            field_dict["page"] = page
        if total is not UNSET:
            field_dict["total"] = total
        if pages is not UNSET:
            field_dict["pages"] = pages
        if dataset_series is not UNSET:
            field_dict["dataset_series"] = dataset_series

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.dataset_series import DatasetSeries

        d = src_dict.copy()
        page = d.pop("page", UNSET)

        total = d.pop("total", UNSET)

        pages = d.pop("pages", UNSET)

        dataset_series = []
        _dataset_series = d.pop("dataset_series", UNSET)
        for dataset_series_item_data in _dataset_series or []:
            dataset_series_item = DatasetSeries.from_dict(dataset_series_item_data)

            dataset_series.append(dataset_series_item)

        dataset_series_list = cls(
            page=page,
            total=total,
            pages=pages,
            dataset_series=dataset_series,
        )

        dataset_series_list.additional_properties = d
        return dataset_series_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.dataset_series import DatasetSeries

    ns["DatasetSeries"] = DatasetSeries
