from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.grant_alarm import GrantAlarm


T = TypeVar("T", bound="GrantAlarmList")


@_attrs_define
class GrantAlarmList:
    """
    Attributes:
        page (Union[Unset, int]): The current page of results.
        total (Union[Unset, int]): The total number of records available.
        pages (Union[Unset, int]): The total number of pages available.
        grant_alarms (Union[Unset, List['GrantAlarm']]):
    """

    page: Union[Unset, int] = UNSET
    total: Union[Unset, int] = UNSET
    pages: Union[Unset, int] = UNSET
    grant_alarms: Union[Unset, List["GrantAlarm"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)
    _immutable_on = {}

    def to_dict(self) -> Dict[str, Any]:
        page = self.page

        total = self.total

        pages = self.pages

        grant_alarms: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.grant_alarms, Unset):
            grant_alarms = []
            for grant_alarms_item_data in self.grant_alarms:
                grant_alarms_item = grant_alarms_item_data.to_dict()
                grant_alarms.append(grant_alarms_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if page is not UNSET:
            field_dict["page"] = page
        if total is not UNSET:
            field_dict["total"] = total
        if pages is not UNSET:
            field_dict["pages"] = pages
        if grant_alarms is not UNSET:
            field_dict["grant_alarms"] = grant_alarms

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.grant_alarm import GrantAlarm

        d = src_dict.copy()
        page = d.pop("page", UNSET)

        total = d.pop("total", UNSET)

        pages = d.pop("pages", UNSET)

        grant_alarms = []
        _grant_alarms = d.pop("grant_alarms", UNSET)
        for grant_alarms_item_data in _grant_alarms or []:
            grant_alarms_item = GrantAlarm.from_dict(grant_alarms_item_data)

            grant_alarms.append(grant_alarms_item)

        grant_alarm_list = cls(
            page=page,
            total=total,
            pages=pages,
            grant_alarms=grant_alarms,
        )

        grant_alarm_list.additional_properties = d
        return grant_alarm_list

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties


def _load_lazy_imports(ns=globals()):
    from ..models.grant_alarm import GrantAlarm

    ns["GrantAlarm"] = GrantAlarm
