import functools

from .api.alarm_grant.list_alarm_grant_logs import (
    asyncio_detailed as list_alarm_grant_logs_asyncio_detailed,
)
from .api.alarm_grant.list_alarm_grants import (
    asyncio_detailed as list_alarm_grants_asyncio_detailed,
)
from .api.change_constraint.list_change_constraints import (
    asyncio_detailed as list_change_constraints_asyncio_detailed,
)
from .api.change_grant.list_change_grants import (
    asyncio_detailed as list_change_grants_asyncio_detailed,
)
from .api.general.get_version import asyncio_detailed as get_version_asyncio_detailed
from .api.subscription.create_subscription import (
    asyncio_detailed as create_subscription_asyncio_detailed,
)
from .api.subscription.delete_subscription import (
    asyncio_detailed as delete_subscription_asyncio_detailed,
)
from .api.subscription.get_subscription_events import (
    asyncio_detailed as get_subscription_events_asyncio_detailed,
)
from .api.subscription.get_subscriptions import (
    asyncio_detailed as get_subscriptions_asyncio_detailed,
)


class ClientApiAsyncioMixin:
    def _call_api_func(self, func, *args, **kwargs):
        return func(*args, **kwargs, client=self)

    @functools.wraps(get_version_asyncio_detailed)
    def get_version(self, *args, **kwargs):
        return self._call_api_func(get_version_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_alarm_grants_asyncio_detailed)
    def list_alarm_grants(self, *args, **kwargs):
        return self._call_api_func(list_alarm_grants_asyncio_detailed, *args, **kwargs)

    @functools.wraps(list_alarm_grant_logs_asyncio_detailed)
    def list_alarm_grant_logs(self, *args, **kwargs):
        return self._call_api_func(
            list_alarm_grant_logs_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(list_change_constraints_asyncio_detailed)
    def list_change_constraints(self, *args, **kwargs):
        return self._call_api_func(
            list_change_constraints_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(list_change_grants_asyncio_detailed)
    def list_change_grants(self, *args, **kwargs):
        return self._call_api_func(list_change_grants_asyncio_detailed, *args, **kwargs)

    @functools.wraps(get_subscriptions_asyncio_detailed)
    def get_subscriptions(self, *args, **kwargs):
        return self._call_api_func(get_subscriptions_asyncio_detailed, *args, **kwargs)

    @functools.wraps(create_subscription_asyncio_detailed)
    def create_subscription(self, *args, **kwargs):
        return self._call_api_func(
            create_subscription_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(delete_subscription_asyncio_detailed)
    def delete_subscription(self, *args, **kwargs):
        return self._call_api_func(
            delete_subscription_asyncio_detailed, *args, **kwargs
        )

    @functools.wraps(get_subscription_events_asyncio_detailed)
    def get_subscription_events(self, *args, **kwargs):
        return self._call_api_func(
            get_subscription_events_asyncio_detailed, *args, **kwargs
        )
